@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Environment Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryEnvironmentVersion = new AzureNative.MachineLearningServices.RegistryEnvironmentVersion("registryEnvironmentVersion", new()
 *     {
 *         EnvironmentName = "string",
 *         EnvironmentVersionProperties = new AzureNative.MachineLearningServices.Inputs.EnvironmentVersionArgs
 *         {
 *             Build = new AzureNative.MachineLearningServices.Inputs.BuildContextArgs
 *             {
 *                 ContextUri = "https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/",
 *                 DockerfilePath = "prod/Dockerfile",
 *             },
 *             CondaFile = "string",
 *             Description = "string",
 *             Image = "docker.io/tensorflow/serving:latest",
 *             InferenceConfig = new AzureNative.MachineLearningServices.Inputs.InferenceContainerPropertiesArgs
 *             {
 *                 LivenessRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *                 ReadinessRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *                 ScoringRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *             },
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewRegistryEnvironmentVersion(ctx, "registryEnvironmentVersion", &machinelearningservices.RegistryEnvironmentVersionArgs{
 * EnvironmentName: pulumi.String("string"),
 * EnvironmentVersionProperties: machinelearningservices.EnvironmentVersionResponse{
 * Build: &machinelearningservices.BuildContextArgs{
 * ContextUri: pulumi.String("https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/"),
 * DockerfilePath: pulumi.String("prod/Dockerfile"),
 * },
 * CondaFile: pulumi.String("string"),
 * Description: pulumi.String("string"),
 * Image: pulumi.String("docker.io/tensorflow/serving:latest"),
 * InferenceConfig: interface{}{
 * LivenessRoute: &machinelearningservices.RouteArgs{
 * Path: pulumi.String("string"),
 * Port: pulumi.Int(1),
 * },
 * ReadinessRoute: &machinelearningservices.RouteArgs{
 * Path: pulumi.String("string"),
 * Port: pulumi.Int(1),
 * },
 * ScoringRoute: &machinelearningservices.RouteArgs{
 * Path: pulumi.String("string"),
 * Port: pulumi.Int(1),
 * },
 * },
 * IsAnonymous: pulumi.Bool(false),
 * Properties: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Tags: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * },
 * RegistryName: pulumi.String("my-aml-registry"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * Version: pulumi.String("string"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryEnvironmentVersion = new RegistryEnvironmentVersion("registryEnvironmentVersion", RegistryEnvironmentVersionArgs.builder()
 *             .environmentName("string")
 *             .environmentVersionProperties(Map.ofEntries(
 *                 Map.entry("build", Map.ofEntries(
 *                     Map.entry("contextUri", "https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/"),
 *                     Map.entry("dockerfilePath", "prod/Dockerfile")
 *                 )),
 *                 Map.entry("condaFile", "string"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("image", "docker.io/tensorflow/serving:latest"),
 *                 Map.entry("inferenceConfig", Map.ofEntries(
 *                     Map.entry("livenessRoute", Map.ofEntries(
 *                         Map.entry("path", "string"),
 *                         Map.entry("port", 1)
 *                     )),
 *                     Map.entry("readinessRoute", Map.ofEntries(
 *                         Map.entry("path", "string"),
 *                         Map.entry("port", 1)
 *                     )),
 *                     Map.entry("scoringRoute", Map.ofEntries(
 *                         Map.entry("path", "string"),
 *                         Map.entry("port", 1)
 *                     ))
 *                 )),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryEnvironmentVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}/versions/{version}
 * ```
 * @property environmentName Container name.
 * @property environmentVersionProperties [Required] Additional attributes of the entity.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 */
public data class RegistryEnvironmentVersionArgs(
    public val environmentName: Output<String>? = null,
    public val environmentVersionProperties: Output<EnvironmentVersionArgs>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersionArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersionArgs.builder()
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .environmentVersionProperties(
                environmentVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryEnvironmentVersionArgs].
 */
@PulumiTagMarker
public class RegistryEnvironmentVersionArgsBuilder internal constructor() {
    private var environmentName: Output<String>? = null

    private var environmentVersionProperties: Output<EnvironmentVersionArgs>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Container name.
     */
    @JvmName("bmjuiyxdqygtxvmh")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("laddchvtqjyhpbfj")
    public suspend fun environmentVersionProperties(`value`: Output<EnvironmentVersionArgs>) {
        this.environmentVersionProperties = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("mlejgbigsnbehfyh")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uwlmatqvlupbgwrf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("rcenncmufrayatfl")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("untikxdycgbuicyf")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("kymyomtbcsyaspbu")
    public suspend fun environmentVersionProperties(`value`: EnvironmentVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("gesymlenyylmptly")
    public suspend
    fun environmentVersionProperties(argument: suspend EnvironmentVersionArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.environmentVersionProperties = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("tldlevwsbekmwqqd")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("spwdhqrmonnwyvrj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("xgiuwxuotraksrnn")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RegistryEnvironmentVersionArgs = RegistryEnvironmentVersionArgs(
        environmentName = environmentName,
        environmentVersionProperties = environmentVersionProperties,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        version = version,
    )
}
