@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ScheduleResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ScheduleResponse.Companion.toKotlin as scheduleResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.Schedule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Schedule(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Schedule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.MachineLearningServices.Schedule("schedule", new()
 *     {
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         ScheduleProperties = new AzureNative.MachineLearningServices.Inputs.ScheduleArgs
 *         {
 *             Action = new AzureNative.MachineLearningServices.Inputs.EndpointScheduleActionArgs
 *             {
 *                 ActionType = "InvokeBatchEndpoint",
 *                 EndpointInvocationDefinition =
 *                 {
 *                     { "9965593e-526f-4b89-bb36-761138cf2794", null },
 *                 },
 *             },
 *             Description = "string",
 *             DisplayName = "string",
 *             IsEnabled = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *             Trigger = new AzureNative.MachineLearningServices.Inputs.CronTriggerArgs
 *             {
 *                 EndTime = "string",
 *                 Expression = "string",
 *                 StartTime = "string",
 *                 TimeZone = "string",
 *                 TriggerType = "Cron",
 *             },
 *         },
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewSchedule(ctx, "schedule", &machinelearningservices.ScheduleArgs{
 * Name: pulumi.String("string"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * ScheduleProperties: interface{}{
 * Action: machinelearningservices.EndpointScheduleAction{
 * ActionType: "InvokeBatchEndpoint",
 * EndpointInvocationDefinition: map[string]interface{}{
 * "9965593e-526f-4b89-bb36-761138cf2794": nil,
 * },
 * },
 * Description: pulumi.String("string"),
 * DisplayName: pulumi.String("string"),
 * IsEnabled: pulumi.Bool(false),
 * Properties: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Tags: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Trigger: machinelearningservices.CronTrigger{
 * EndTime: "string",
 * Expression: "string",
 * StartTime: "string",
 * TimeZone: "string",
 * TriggerType: "Cron",
 * },
 * },
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Schedule;
 * import com.pulumi.azurenative.machinelearningservices.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .scheduleProperties(Map.ofEntries(
 *                 Map.entry("action", Map.ofEntries(
 *                     Map.entry("actionType", "InvokeBatchEndpoint"),
 *                     Map.entry("endpointInvocationDefinition", ScheduleArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))
 *                     )),
 *                     Map.entry("description", "string"),
 *                     Map.entry("displayName", "string"),
 *                     Map.entry("isEnabled", false),
 *                     Map.entry("properties", Map.of("string", "string")),
 *                     Map.entry("tags", Map.of("string", "string")),
 *                     Map.entry("trigger", Map.ofEntries(
 *                         Map.entry("endTime", "string"),
 *                         Map.entry("expression", "string"),
 *                         Map.entry("startTime", "string"),
 *                         Map.entry("timeZone", "string"),
 *                         Map.entry("triggerType", "Cron")
 *                     ))
 *                 ))
 *                 .workspaceName("my-aml-workspace")
 *                 .build());
 *         }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Schedule string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/schedules/{name}
 * ```
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * [Required] Additional attributes of the entity.
     */
    public val scheduleProperties: Output<ScheduleResponse>
        get() = javaResource.scheduleProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                scheduleResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit):
    Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
