@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Schedule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.MachineLearningServices.Schedule("schedule", new()
 *     {
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         ScheduleProperties = new AzureNative.MachineLearningServices.Inputs.ScheduleArgs
 *         {
 *             Action = new AzureNative.MachineLearningServices.Inputs.EndpointScheduleActionArgs
 *             {
 *                 ActionType = "InvokeBatchEndpoint",
 *                 EndpointInvocationDefinition =
 *                 {
 *                     { "9965593e-526f-4b89-bb36-761138cf2794", null },
 *                 },
 *             },
 *             Description = "string",
 *             DisplayName = "string",
 *             IsEnabled = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *             Trigger = new AzureNative.MachineLearningServices.Inputs.CronTriggerArgs
 *             {
 *                 EndTime = "string",
 *                 Expression = "string",
 *                 StartTime = "string",
 *                 TimeZone = "string",
 *                 TriggerType = "Cron",
 *             },
 *         },
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewSchedule(ctx, "schedule", &machinelearningservices.ScheduleArgs{
 * Name: pulumi.String("string"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * ScheduleProperties: interface{}{
 * Action: machinelearningservices.EndpointScheduleAction{
 * ActionType: "InvokeBatchEndpoint",
 * EndpointInvocationDefinition: map[string]interface{}{
 * "9965593e-526f-4b89-bb36-761138cf2794": nil,
 * },
 * },
 * Description: pulumi.String("string"),
 * DisplayName: pulumi.String("string"),
 * IsEnabled: pulumi.Bool(false),
 * Properties: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Tags: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Trigger: machinelearningservices.CronTrigger{
 * EndTime: "string",
 * Expression: "string",
 * StartTime: "string",
 * TimeZone: "string",
 * TriggerType: "Cron",
 * },
 * },
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Schedule;
 * import com.pulumi.azurenative.machinelearningservices.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .scheduleProperties(Map.ofEntries(
 *                 Map.entry("action", Map.ofEntries(
 *                     Map.entry("actionType", "InvokeBatchEndpoint"),
 *                     Map.entry("endpointInvocationDefinition", ScheduleArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))
 *                     )),
 *                     Map.entry("description", "string"),
 *                     Map.entry("displayName", "string"),
 *                     Map.entry("isEnabled", false),
 *                     Map.entry("properties", Map.of("string", "string")),
 *                     Map.entry("tags", Map.of("string", "string")),
 *                     Map.entry("trigger", Map.ofEntries(
 *                         Map.entry("endTime", "string"),
 *                         Map.entry("expression", "string"),
 *                         Map.entry("startTime", "string"),
 *                         Map.entry("timeZone", "string"),
 *                         Map.entry("triggerType", "Cron")
 *                     ))
 *                 ))
 *                 .workspaceName("my-aml-workspace")
 *                 .build());
 *         }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Schedule string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/schedules/{name}
 * ```
 * @property name Schedule name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scheduleProperties [Required] Additional attributes of the entity.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ScheduleArgs(
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ScheduleArgs>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.ScheduleArgs =
        com.pulumi.azurenative.machinelearningservices.ScheduleArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleProperties(
                scheduleProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ScheduleArgs>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Schedule name.
     */
    @JvmName("jpjhfhdotbvwchqx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uwducjykfckgjuxh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("rcnxtnsftfdywyax")
    public suspend
    fun scheduleProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ScheduleArgs>) {
        this.scheduleProperties = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("tpnkxqprwgokwwgc")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Schedule name.
     */
    @JvmName("nhaoimhausiboeic")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oduyaskgfgwxdprd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("rvghffqlrnlpdunj")
    public suspend
    fun scheduleProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("vuxubqgbmwexuryc")
    public suspend
    fun scheduleProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ScheduleArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ScheduleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scheduleProperties = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("pkyfkkerfstbaiou")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        name = name,
        resourceGroupName = resourceGroupName,
        scheduleProperties = scheduleProperties,
        workspaceName = workspaceName,
    )
}
