@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enum for all classification models supported by AutoML.
 */
public enum class BlockedTransformers(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers> {
    /**
     * Target encoding for text data.
     */
    TextTargetEncoder(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.TextTargetEncoder),

    /**
     * Ohe hot encoding creates a binary feature transformation.
     */
    OneHotEncoder(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.OneHotEncoder),

    /**
     * Target encoding for categorical data.
     */
    CatTargetEncoder(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.CatTargetEncoder),

    /**
     * Tf-Idf stands for, term-frequency times inverse document-frequency. This is a common term weighting scheme for identifying information from documents.
     */
    TfIdf(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.TfIdf),

    /**
     * Weight of Evidence encoding is a technique used to encode categorical variables. It uses the natural log of the P(1)/P(0) to create weights.
     */
    WoETargetEncoder(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.WoETargetEncoder),

    /**
     * Label encoder converts labels/categorical variables in a numerical form.
     */
    LabelEncoder(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.LabelEncoder),

    /**
     * Word embedding helps represents words or phrases as a vector, or a series of numbers.
     */
    WordEmbedding(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.WordEmbedding),

    /**
     * Naive Bayes is a classified that is used for classification of discrete features that are categorically distributed.
     */
    NaiveBayes(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.NaiveBayes),

    /**
     * Count Vectorizer converts a collection of text documents to a matrix of token counts.
     */
    CountVectorizer(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.CountVectorizer),

    /**
     * Hashing One Hot Encoder can turn categorical variables into a limited number of new features. This is often used for high-cardinality categorical features.
     */
    HashOneHotEncoder(com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers.HashOneHotEncoder),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.BlockedTransformers):
            BlockedTransformers = BlockedTransformers.values().first { it.javaValue == javaType }
    }
}
