@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Log verbosity for the job.
 */
public enum class LogVerbosity(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity> {
    /**
     * No logs emitted.
     */
    NotSet(com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity.NotSet),

    /**
     * Debug and above log statements logged.
     */
    Debug(com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity.Debug),

    /**
     * Info and above log statements logged.
     */
    Info(com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity.Info),

    /**
     * Warning and above log statements logged.
     */
    Warning(com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity.Warning),

    /**
     * Error and above log statements logged.
     */
    Error(com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity.Error),

    /**
     * Only critical statements logged.
     */
    Critical(com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity.Critical),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.LogVerbosity):
            LogVerbosity = LogVerbosity.values().first { it.javaValue == javaType }
    }
}
