@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
 */
public enum class PublicNetworkAccessType(
    public val javaValue:
    com.pulumi.azurenative.machinelearningservices.enums.PublicNetworkAccessType,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.PublicNetworkAccessType> {
    Enabled(com.pulumi.azurenative.machinelearningservices.enums.PublicNetworkAccessType.Enabled),
    Disabled(com.pulumi.azurenative.machinelearningservices.enums.PublicNetworkAccessType.Disabled),
    ;

    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.enums.PublicNetworkAccessType = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.PublicNetworkAccessType):
            PublicNetworkAccessType =
            PublicNetworkAccessType.values().first { it.javaValue == javaType }
    }
}
