@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AKSArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A Machine Learning compute based on AKS.
 * @property computeLocation Location for the underlying compute
 * @property computeType The type of compute
 * Expected value is 'AKS'.
 * @property description The description of the Machine Learning compute.
 * @property disableLocalAuth Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
 * @property properties AKS properties
 * @property resourceId ARM resource id of the underlying compute
 */
public data class AKSArgs(
    public val computeLocation: Output<String>? = null,
    public val computeType: Output<String>,
    public val description: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val properties: Output<AKSSchemaPropertiesArgs>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AKSArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AKSArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AKSArgs.builder()
            .computeLocation(computeLocation?.applyValue({ args0 -> args0 }))
            .computeType(computeType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AKSArgs].
 */
@PulumiTagMarker
public class AKSArgsBuilder internal constructor() {
    private var computeLocation: Output<String>? = null

    private var computeType: Output<String>? = null

    private var description: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var properties: Output<AKSSchemaPropertiesArgs>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Location for the underlying compute
     */
    @JvmName("bwuetqeofbflprvh")
    public suspend fun computeLocation(`value`: Output<String>) {
        this.computeLocation = value
    }

    /**
     * @param value The type of compute
     * Expected value is 'AKS'.
     */
    @JvmName("afheeadiljfhgkdp")
    public suspend fun computeType(`value`: Output<String>) {
        this.computeType = value
    }

    /**
     * @param value The description of the Machine Learning compute.
     */
    @JvmName("kntotluqwytduxio")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
     */
    @JvmName("ebwjjpfmiebiofof")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value AKS properties
     */
    @JvmName("vwxmslptrjecvnqy")
    public suspend fun properties(`value`: Output<AKSSchemaPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value ARM resource id of the underlying compute
     */
    @JvmName("mktmtaoqmeqjgmiy")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Location for the underlying compute
     */
    @JvmName("velhbqprsyalvwxu")
    public suspend fun computeLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeLocation = mapped
    }

    /**
     * @param value The type of compute
     * Expected value is 'AKS'.
     */
    @JvmName("xcthvdontcuntisi")
    public suspend fun computeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value The description of the Machine Learning compute.
     */
    @JvmName("thslqgdjtoogykfb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
     */
    @JvmName("hwxholodmljcabug")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value AKS properties
     */
    @JvmName("vnhsshdxqkjrgayb")
    public suspend fun properties(`value`: AKSSchemaPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument AKS properties
     */
    @JvmName("kbysathnvjgjller")
    public suspend fun properties(argument: suspend AKSSchemaPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AKSSchemaPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value ARM resource id of the underlying compute
     */
    @JvmName("suyohdrcsobkxyfy")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): AKSArgs = AKSArgs(
        computeLocation = computeLocation,
        computeType = computeType ?: throw PulumiNullFieldException("computeType"),
        description = description,
        disableLocalAuth = disableLocalAuth,
        properties = properties,
        resourceId = resourceId,
    )
}
