@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AmlComputePropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.OsType
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RemoteLoginPortPublicAccess
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.VmPriority
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * AML Compute properties
 * @property enableNodePublicIp Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
 * @property isolatedNetwork Network is isolated or not
 * @property osType Compute OS Type
 * @property propertyBag A property bag containing additional properties.
 * @property remoteLoginPortPublicAccess State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
 * @property scaleSettings Scale settings for AML Compute
 * @property subnet Virtual network subnet resource ID the compute nodes belong to.
 * @property userAccountCredentials Credentials for an administrator user account that will be created on each compute node.
 * @property virtualMachineImage Virtual Machine image for AML Compute - windows only
 * @property vmPriority Virtual Machine priority
 * @property vmSize Virtual Machine Size
 */
public data class AmlComputePropertiesArgs(
    public val enableNodePublicIp: Output<Boolean>? = null,
    public val isolatedNetwork: Output<Boolean>? = null,
    public val osType: Output<Either<String, OsType>>? = null,
    public val propertyBag: Output<Any>? = null,
    public val remoteLoginPortPublicAccess: Output<Either<String, RemoteLoginPortPublicAccess>>? =
        null,
    public val scaleSettings: Output<ScaleSettingsArgs>? = null,
    public val subnet: Output<ResourceIdArgs>? = null,
    public val userAccountCredentials: Output<UserAccountCredentialsArgs>? = null,
    public val virtualMachineImage: Output<VirtualMachineImageArgs>? = null,
    public val vmPriority: Output<Either<String, VmPriority>>? = null,
    public val vmSize: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AmlComputePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AmlComputePropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AmlComputePropertiesArgs.builder()
            .enableNodePublicIp(enableNodePublicIp?.applyValue({ args0 -> args0 }))
            .isolatedNetwork(isolatedNetwork?.applyValue({ args0 -> args0 }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .propertyBag(propertyBag?.applyValue({ args0 -> args0 }))
            .remoteLoginPortPublicAccess(
                remoteLoginPortPublicAccess?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .scaleSettings(scaleSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAccountCredentials(
                userAccountCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualMachineImage(
                virtualMachineImage?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vmPriority(
                vmPriority?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmlComputePropertiesArgs].
 */
@PulumiTagMarker
public class AmlComputePropertiesArgsBuilder internal constructor() {
    private var enableNodePublicIp: Output<Boolean>? = null

    private var isolatedNetwork: Output<Boolean>? = null

    private var osType: Output<Either<String, OsType>>? = null

    private var propertyBag: Output<Any>? = null

    private var remoteLoginPortPublicAccess: Output<Either<String, RemoteLoginPortPublicAccess>>? =
        null

    private var scaleSettings: Output<ScaleSettingsArgs>? = null

    private var subnet: Output<ResourceIdArgs>? = null

    private var userAccountCredentials: Output<UserAccountCredentialsArgs>? = null

    private var virtualMachineImage: Output<VirtualMachineImageArgs>? = null

    private var vmPriority: Output<Either<String, VmPriority>>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
     */
    @JvmName("nqyocvlbjbtmcana")
    public suspend fun enableNodePublicIp(`value`: Output<Boolean>) {
        this.enableNodePublicIp = value
    }

    /**
     * @param value Network is isolated or not
     */
    @JvmName("mxcnvcarivrycnti")
    public suspend fun isolatedNetwork(`value`: Output<Boolean>) {
        this.isolatedNetwork = value
    }

    /**
     * @param value Compute OS Type
     */
    @JvmName("hhueieugbbggrpij")
    public suspend fun osType(`value`: Output<Either<String, OsType>>) {
        this.osType = value
    }

    /**
     * @param value A property bag containing additional properties.
     */
    @JvmName("dhqbwvqrwqipphey")
    public suspend fun propertyBag(`value`: Output<Any>) {
        this.propertyBag = value
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
     */
    @JvmName("fwhuoqyeoevxcryk")
    public suspend
    fun remoteLoginPortPublicAccess(`value`: Output<Either<String, RemoteLoginPortPublicAccess>>) {
        this.remoteLoginPortPublicAccess = value
    }

    /**
     * @param value Scale settings for AML Compute
     */
    @JvmName("ogljrlaotiimtpnd")
    public suspend fun scaleSettings(`value`: Output<ScaleSettingsArgs>) {
        this.scaleSettings = value
    }

    /**
     * @param value Virtual network subnet resource ID the compute nodes belong to.
     */
    @JvmName("aiiubfiykrronmft")
    public suspend fun subnet(`value`: Output<ResourceIdArgs>) {
        this.subnet = value
    }

    /**
     * @param value Credentials for an administrator user account that will be created on each compute node.
     */
    @JvmName("vkailhqoyhujqlck")
    public suspend fun userAccountCredentials(`value`: Output<UserAccountCredentialsArgs>) {
        this.userAccountCredentials = value
    }

    /**
     * @param value Virtual Machine image for AML Compute - windows only
     */
    @JvmName("urbkjvopjukogqws")
    public suspend fun virtualMachineImage(`value`: Output<VirtualMachineImageArgs>) {
        this.virtualMachineImage = value
    }

    /**
     * @param value Virtual Machine priority
     */
    @JvmName("jkbrmcbxpmstdusk")
    public suspend fun vmPriority(`value`: Output<Either<String, VmPriority>>) {
        this.vmPriority = value
    }

    /**
     * @param value Virtual Machine Size
     */
    @JvmName("qdxaancnieetsiap")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
     */
    @JvmName("ohwdtnqjoeoolpfh")
    public suspend fun enableNodePublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNodePublicIp = mapped
    }

    /**
     * @param value Network is isolated or not
     */
    @JvmName("barbmgrtrknedpvw")
    public suspend fun isolatedNetwork(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isolatedNetwork = mapped
    }

    /**
     * @param value Compute OS Type
     */
    @JvmName("oeocougbfunqfrbv")
    public suspend fun osType(`value`: Either<String, OsType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Compute OS Type
     */
    @JvmName("hxtumbbtselcjnvg")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Compute OS Type
     */
    @JvmName("ensvvvnudcnplgib")
    public fun osType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value A property bag containing additional properties.
     */
    @JvmName("exdrrpydhkybocpq")
    public suspend fun propertyBag(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyBag = mapped
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
     */
    @JvmName("bcuskwjqtepqtvdv")
    public suspend
    fun remoteLoginPortPublicAccess(`value`: Either<String, RemoteLoginPortPublicAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteLoginPortPublicAccess = mapped
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
     */
    @JvmName("vmkojaxrxjiwciys")
    public fun remoteLoginPortPublicAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RemoteLoginPortPublicAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteLoginPortPublicAccess = mapped
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
     */
    @JvmName("lwkfuonlnkidrjwe")
    public fun remoteLoginPortPublicAccess(`value`: RemoteLoginPortPublicAccess) {
        val toBeMapped = Either.ofRight<String, RemoteLoginPortPublicAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteLoginPortPublicAccess = mapped
    }

    /**
     * @param value Scale settings for AML Compute
     */
    @JvmName("pmuinqfspxcqgbmu")
    public suspend fun scaleSettings(`value`: ScaleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleSettings = mapped
    }

    /**
     * @param argument Scale settings for AML Compute
     */
    @JvmName("wkwtgpjlmgmhjjjv")
    public suspend fun scaleSettings(argument: suspend ScaleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scaleSettings = mapped
    }

    /**
     * @param value Virtual network subnet resource ID the compute nodes belong to.
     */
    @JvmName("txnnxaosrludgldm")
    public suspend fun subnet(`value`: ResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Virtual network subnet resource ID the compute nodes belong to.
     */
    @JvmName("rabhwtongpqgcyhs")
    public suspend fun subnet(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Credentials for an administrator user account that will be created on each compute node.
     */
    @JvmName("qrdtowmcprximadx")
    public suspend fun userAccountCredentials(`value`: UserAccountCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAccountCredentials = mapped
    }

    /**
     * @param argument Credentials for an administrator user account that will be created on each compute node.
     */
    @JvmName("wrqqvgsodiyjmsjj")
    public suspend
    fun userAccountCredentials(argument: suspend UserAccountCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = UserAccountCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userAccountCredentials = mapped
    }

    /**
     * @param value Virtual Machine image for AML Compute - windows only
     */
    @JvmName("hcmsdffkkkitvbrd")
    public suspend fun virtualMachineImage(`value`: VirtualMachineImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineImage = mapped
    }

    /**
     * @param argument Virtual Machine image for AML Compute - windows only
     */
    @JvmName("txvwvhxfhuitanss")
    public suspend
    fun virtualMachineImage(argument: suspend VirtualMachineImageArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineImage = mapped
    }

    /**
     * @param value Virtual Machine priority
     */
    @JvmName("wccsbpwtqfkvknee")
    public suspend fun vmPriority(`value`: Either<String, VmPriority>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmPriority = mapped
    }

    /**
     * @param value Virtual Machine priority
     */
    @JvmName("wdsbedtuevkkjhsp")
    public fun vmPriority(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VmPriority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmPriority = mapped
    }

    /**
     * @param value Virtual Machine priority
     */
    @JvmName("uokygkcgfrqcefkw")
    public fun vmPriority(`value`: VmPriority) {
        val toBeMapped = Either.ofRight<String, VmPriority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmPriority = mapped
    }

    /**
     * @param value Virtual Machine Size
     */
    @JvmName("ljvnbjvrpcimvotr")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): AmlComputePropertiesArgs = AmlComputePropertiesArgs(
        enableNodePublicIp = enableNodePublicIp,
        isolatedNetwork = isolatedNetwork,
        osType = osType,
        propertyBag = propertyBag,
        remoteLoginPortPublicAccess = remoteLoginPortPublicAccess,
        scaleSettings = scaleSettings,
        subnet = subnet,
        userAccountCredentials = userAccountCredentials,
        virtualMachineImage = virtualMachineImage,
        vmPriority = vmPriority,
        vmSize = vmSize,
    )
}
