@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AssignedUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A user that can be assigned to a compute instance.
 * @property objectId User’s AAD Object Id.
 * @property tenantId User’s AAD Tenant Id.
 */
public data class AssignedUserArgs(
    public val objectId: Output<String>,
    public val tenantId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AssignedUserArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AssignedUserArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AssignedUserArgs.builder()
            .objectId(objectId.applyValue({ args0 -> args0 }))
            .tenantId(tenantId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignedUserArgs].
 */
@PulumiTagMarker
public class AssignedUserArgsBuilder internal constructor() {
    private var objectId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value User’s AAD Object Id.
     */
    @JvmName("hckgjlnaunduntsj")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value User’s AAD Tenant Id.
     */
    @JvmName("adberwosmeyupqrm")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value User’s AAD Object Id.
     */
    @JvmName("eeoblegqenybryej")
    public suspend fun objectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value User’s AAD Tenant Id.
     */
    @JvmName("bqesnapmgaajyhki")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AssignedUserArgs = AssignedUserArgs(
        objectId = objectId ?: throw PulumiNullFieldException("objectId"),
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
    )
}
