@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetRollingWindowSizeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Target lags rolling window determined automatically.
 * @property mode Target rolling windows size mode.
 * Expected value is 'Auto'.
 */
public data class AutoTargetRollingWindowSizeArgs(
    public val mode: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetRollingWindowSizeArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetRollingWindowSizeArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetRollingWindowSizeArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoTargetRollingWindowSizeArgs].
 */
@PulumiTagMarker
public class AutoTargetRollingWindowSizeArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value Target rolling windows size mode.
     * Expected value is 'Auto'.
     */
    @JvmName("syomaonkdajoecjx")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Target rolling windows size mode.
     * Expected value is 'Auto'.
     */
    @JvmName("bklmpngmiyqofhqk")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): AutoTargetRollingWindowSizeArgs = AutoTargetRollingWindowSizeArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
