@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BanditPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation
 * @property delayEvaluation Number of intervals by which to delay the first evaluation.
 * @property evaluationInterval Interval (number of runs) between policy evaluations.
 * @property policyType
 * Expected value is 'Bandit'.
 * @property slackAmount Absolute distance allowed from the best performing run.
 * @property slackFactor Ratio of the allowed distance from the best performing run.
 */
public data class BanditPolicyArgs(
    public val delayEvaluation: Output<Int>? = null,
    public val evaluationInterval: Output<Int>? = null,
    public val policyType: Output<String>,
    public val slackAmount: Output<Double>? = null,
    public val slackFactor: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BanditPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.BanditPolicyArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BanditPolicyArgs.builder()
            .delayEvaluation(delayEvaluation?.applyValue({ args0 -> args0 }))
            .evaluationInterval(evaluationInterval?.applyValue({ args0 -> args0 }))
            .policyType(policyType.applyValue({ args0 -> args0 }))
            .slackAmount(slackAmount?.applyValue({ args0 -> args0 }))
            .slackFactor(slackFactor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BanditPolicyArgs].
 */
@PulumiTagMarker
public class BanditPolicyArgsBuilder internal constructor() {
    private var delayEvaluation: Output<Int>? = null

    private var evaluationInterval: Output<Int>? = null

    private var policyType: Output<String>? = null

    private var slackAmount: Output<Double>? = null

    private var slackFactor: Output<Double>? = null

    /**
     * @param value Number of intervals by which to delay the first evaluation.
     */
    @JvmName("axotepwbmkwgmsjs")
    public suspend fun delayEvaluation(`value`: Output<Int>) {
        this.delayEvaluation = value
    }

    /**
     * @param value Interval (number of runs) between policy evaluations.
     */
    @JvmName("mhojrowovgyspcuk")
    public suspend fun evaluationInterval(`value`: Output<Int>) {
        this.evaluationInterval = value
    }

    /**
     * @param value
     * Expected value is 'Bandit'.
     */
    @JvmName("jxjbqgqmeikggmuw")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value Absolute distance allowed from the best performing run.
     */
    @JvmName("nwmoomcuxfommnug")
    public suspend fun slackAmount(`value`: Output<Double>) {
        this.slackAmount = value
    }

    /**
     * @param value Ratio of the allowed distance from the best performing run.
     */
    @JvmName("xneasulbjlbylwdg")
    public suspend fun slackFactor(`value`: Output<Double>) {
        this.slackFactor = value
    }

    /**
     * @param value Number of intervals by which to delay the first evaluation.
     */
    @JvmName("egbanrewbfwfnynx")
    public suspend fun delayEvaluation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayEvaluation = mapped
    }

    /**
     * @param value Interval (number of runs) between policy evaluations.
     */
    @JvmName("uvbpjfwmhddoughh")
    public suspend fun evaluationInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationInterval = mapped
    }

    /**
     * @param value
     * Expected value is 'Bandit'.
     */
    @JvmName("kwswouwhpapibcmn")
    public suspend fun policyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Absolute distance allowed from the best performing run.
     */
    @JvmName("bqwtrboltomefqwh")
    public suspend fun slackAmount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackAmount = mapped
    }

    /**
     * @param value Ratio of the allowed distance from the best performing run.
     */
    @JvmName("myqpyytbbwpjfrjs")
    public suspend fun slackFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackFactor = mapped
    }

    internal fun build(): BanditPolicyArgs = BanditPolicyArgs(
        delayEvaluation = delayEvaluation,
        evaluationInterval = evaluationInterval,
        policyType = policyType ?: throw PulumiNullFieldException("policyType"),
        slackAmount = slackAmount,
        slackFactor = slackFactor,
    )
}
