@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.EndpointAuthMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Batch endpoint configuration.
 * @property authMode [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
 * @property defaults Default values for Batch Endpoint
 * @property description Description of the inference endpoint.
 * @property keys EndpointAuthKeys to set initially on an Endpoint.
 * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 */
public data class BatchEndpointArgs(
    public val authMode: Output<Either<String, EndpointAuthMode>>,
    public val defaults: Output<BatchEndpointDefaultsArgs>? = null,
    public val description: Output<String>? = null,
    public val keys: Output<EndpointAuthKeysArgs>? = null,
    public val properties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointArgs.builder()
            .authMode(
                authMode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaults(defaults?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .keys(keys?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BatchEndpointArgs].
 */
@PulumiTagMarker
public class BatchEndpointArgsBuilder internal constructor() {
    private var authMode: Output<Either<String, EndpointAuthMode>>? = null

    private var defaults: Output<BatchEndpointDefaultsArgs>? = null

    private var description: Output<String>? = null

    private var keys: Output<EndpointAuthKeysArgs>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("ypjmtwmqwdnxmiqx")
    public suspend fun authMode(`value`: Output<Either<String, EndpointAuthMode>>) {
        this.authMode = value
    }

    /**
     * @param value Default values for Batch Endpoint
     */
    @JvmName("rukcdmveiiuidmrh")
    public suspend fun defaults(`value`: Output<BatchEndpointDefaultsArgs>) {
        this.defaults = value
    }

    /**
     * @param value Description of the inference endpoint.
     */
    @JvmName("mtpnxmefhwftwttk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value EndpointAuthKeys to set initially on an Endpoint.
     * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
     */
    @JvmName("fulofmbikuferoen")
    public suspend fun keys(`value`: Output<EndpointAuthKeysArgs>) {
        this.keys = value
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("elsaqbwiqrhbabma")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("ugucyfmqctluahub")
    public suspend fun authMode(`value`: Either<String, EndpointAuthMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("bevellfoeagncwyq")
    public fun authMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("lmavpwpwshtvwslx")
    public fun authMode(`value`: EndpointAuthMode) {
        val toBeMapped = Either.ofRight<String, EndpointAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value Default values for Batch Endpoint
     */
    @JvmName("xnooygfwagasqtyh")
    public suspend fun defaults(`value`: BatchEndpointDefaultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaults = mapped
    }

    /**
     * @param argument Default values for Batch Endpoint
     */
    @JvmName("waqlbsxmcvyhjaot")
    public suspend fun defaults(argument: suspend BatchEndpointDefaultsArgsBuilder.() -> Unit) {
        val toBeMapped = BatchEndpointDefaultsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaults = mapped
    }

    /**
     * @param value Description of the inference endpoint.
     */
    @JvmName("avhnxafnbmaafflr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value EndpointAuthKeys to set initially on an Endpoint.
     * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
     */
    @JvmName("mmdfnehytpscdtor")
    public suspend fun keys(`value`: EndpointAuthKeysArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param argument EndpointAuthKeys to set initially on an Endpoint.
     * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
     */
    @JvmName("hqwhxtbyuehbiawn")
    public suspend fun keys(argument: suspend EndpointAuthKeysArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointAuthKeysArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keys = mapped
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("ijmlncevwftyjefp")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("mamhqkeqjbdutbdg")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): BatchEndpointArgs = BatchEndpointArgs(
        authMode = authMode ?: throw PulumiNullFieldException("authMode"),
        defaults = defaults,
        description = description,
        keys = keys,
        properties = properties,
    )
}
