@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointDefaultsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Batch endpoint default values
 * @property deploymentName Name of the deployment that will be default for the endpoint.
 * This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
 */
public data class BatchEndpointDefaultsArgs(
    public val deploymentName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointDefaultsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointDefaultsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BatchEndpointDefaultsArgs.builder()
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BatchEndpointDefaultsArgs].
 */
@PulumiTagMarker
public class BatchEndpointDefaultsArgsBuilder internal constructor() {
    private var deploymentName: Output<String>? = null

    /**
     * @param value Name of the deployment that will be default for the endpoint.
     * This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
     */
    @JvmName("ldhqvyaqwwpwnmwu")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value Name of the deployment that will be default for the endpoint.
     * This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
     */
    @JvmName("ililelgahmgduwmi")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    internal fun build(): BatchEndpointDefaultsArgs = BatchEndpointDefaultsArgs(
        deploymentName = deploymentName,
    )
}
