@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Certificate datastore credentials configuration.
 * @property authorityUrl Authority URL used for authentication.
 * @property clientId [Required] Service principal client ID.
 * @property credentialsType Enum to determine the datastore credentials type.
 * Expected value is 'Certificate'.
 * @property resourceUrl Resource the service principal has access to.
 * @property secrets [Required] Service principal secrets.
 * @property tenantId [Required] ID of the tenant to which the service principal belongs.
 * @property thumbprint [Required] Thumbprint of the certificate used for authentication.
 */
public data class CertificateDatastoreCredentialsArgs(
    public val authorityUrl: Output<String>? = null,
    public val clientId: Output<String>,
    public val credentialsType: Output<String>,
    public val resourceUrl: Output<String>? = null,
    public val secrets: Output<CertificateDatastoreSecretsArgs>,
    public val tenantId: Output<String>,
    public val thumbprint: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreCredentialsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreCredentialsArgs.builder()
            .authorityUrl(authorityUrl?.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .credentialsType(credentialsType.applyValue({ args0 -> args0 }))
            .resourceUrl(resourceUrl?.applyValue({ args0 -> args0 }))
            .secrets(secrets.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tenantId(tenantId.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateDatastoreCredentialsArgs].
 */
@PulumiTagMarker
public class CertificateDatastoreCredentialsArgsBuilder internal constructor() {
    private var authorityUrl: Output<String>? = null

    private var clientId: Output<String>? = null

    private var credentialsType: Output<String>? = null

    private var resourceUrl: Output<String>? = null

    private var secrets: Output<CertificateDatastoreSecretsArgs>? = null

    private var tenantId: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value Authority URL used for authentication.
     */
    @JvmName("tqfeyrlwpovxiluv")
    public suspend fun authorityUrl(`value`: Output<String>) {
        this.authorityUrl = value
    }

    /**
     * @param value [Required] Service principal client ID.
     */
    @JvmName("jmiwapyyiujojdsc")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'Certificate'.
     */
    @JvmName("dvqggcivnjxuovbq")
    public suspend fun credentialsType(`value`: Output<String>) {
        this.credentialsType = value
    }

    /**
     * @param value Resource the service principal has access to.
     */
    @JvmName("mupxkyolfnntefqe")
    public suspend fun resourceUrl(`value`: Output<String>) {
        this.resourceUrl = value
    }

    /**
     * @param value [Required] Service principal secrets.
     */
    @JvmName("pmhkcftnoddytjjs")
    public suspend fun secrets(`value`: Output<CertificateDatastoreSecretsArgs>) {
        this.secrets = value
    }

    /**
     * @param value [Required] ID of the tenant to which the service principal belongs.
     */
    @JvmName("qxawhmiicnqnmkua")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value [Required] Thumbprint of the certificate used for authentication.
     */
    @JvmName("utithuxuidygmeqp")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Authority URL used for authentication.
     */
    @JvmName("uavprbolocpkymvk")
    public suspend fun authorityUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorityUrl = mapped
    }

    /**
     * @param value [Required] Service principal client ID.
     */
    @JvmName("hpuqyuqkddoigvps")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'Certificate'.
     */
    @JvmName("gnuxglhsvynvkdcl")
    public suspend fun credentialsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsType = mapped
    }

    /**
     * @param value Resource the service principal has access to.
     */
    @JvmName("agiesiggjhqkuomv")
    public suspend fun resourceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUrl = mapped
    }

    /**
     * @param value [Required] Service principal secrets.
     */
    @JvmName("bvejavrxvoqxbiod")
    public suspend fun secrets(`value`: CertificateDatastoreSecretsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument [Required] Service principal secrets.
     */
    @JvmName("bynxypndhjiskgfx")
    public suspend fun secrets(argument: suspend CertificateDatastoreSecretsArgsBuilder.() -> Unit) {
        val toBeMapped = CertificateDatastoreSecretsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param value [Required] ID of the tenant to which the service principal belongs.
     */
    @JvmName("hpyjvndewuyclock")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value [Required] Thumbprint of the certificate used for authentication.
     */
    @JvmName("peyufuoctgkdxuok")
    public suspend fun thumbprint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): CertificateDatastoreCredentialsArgs = CertificateDatastoreCredentialsArgs(
        authorityUrl = authorityUrl,
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        credentialsType = credentialsType ?: throw PulumiNullFieldException("credentialsType"),
        resourceUrl = resourceUrl,
        secrets = secrets ?: throw PulumiNullFieldException("secrets"),
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
        thumbprint = thumbprint ?: throw PulumiNullFieldException("thumbprint"),
    )
}
