@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ClassificationPrimaryMetrics
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LogVerbosity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Classification task in AutoML Table vertical.
 * @property cvSplitColumnNames Columns to use for CVSplit data.
 * @property featurizationSettings Featurization inputs needed for AutoML job.
 * @property limitSettings Execution constraints for AutoMLJob.
 * @property logVerbosity Log verbosity for the job.
 * @property nCrossValidations Number of cross validation folds to be applied on training dataset
 * when validation dataset is not provided.
 * @property positiveLabel Positive label for binary metrics calculation.
 * @property primaryMetric Primary metric for the task.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'Classification'.
 * @property testData Test data input.
 * @property testDataSize The fraction of test dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property trainingData [Required] Training data input.
 * @property trainingSettings Inputs for training phase for an AutoML Job.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property weightColumnName The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
 */
public data class ClassificationArgs(
    public val cvSplitColumnNames: Output<List<String>>? = null,
    public val featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null,
    public val limitSettings: Output<TableVerticalLimitSettingsArgs>? = null,
    public val logVerbosity: Output<Either<String, LogVerbosity>>? = null,
    public val nCrossValidations:
    Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null,
    public val positiveLabel: Output<String>? = null,
    public val primaryMetric: Output<Either<String, ClassificationPrimaryMetrics>>? = null,
    public val targetColumnName: Output<String>? = null,
    public val taskType: Output<String>,
    public val testData: Output<MLTableJobInputArgs>? = null,
    public val testDataSize: Output<Double>? = null,
    public val trainingData: Output<MLTableJobInputArgs>,
    public val trainingSettings: Output<ClassificationTrainingSettingsArgs>? = null,
    public val validationData: Output<MLTableJobInputArgs>? = null,
    public val validationDataSize: Output<Double>? = null,
    public val weightColumnName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs.builder()
            .cvSplitColumnNames(cvSplitColumnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .featurizationSettings(
                featurizationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .limitSettings(limitSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logVerbosity(
                logVerbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nCrossValidations(
                nCrossValidations?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .positiveLabel(positiveLabel?.applyValue({ args0 -> args0 }))
            .primaryMetric(
                primaryMetric?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetColumnName(targetColumnName?.applyValue({ args0 -> args0 }))
            .taskType(taskType.applyValue({ args0 -> args0 }))
            .testData(testData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .testDataSize(testDataSize?.applyValue({ args0 -> args0 }))
            .trainingData(trainingData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trainingSettings(trainingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationData(validationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationDataSize(validationDataSize?.applyValue({ args0 -> args0 }))
            .weightColumnName(weightColumnName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassificationArgs].
 */
@PulumiTagMarker
public class ClassificationArgsBuilder internal constructor() {
    private var cvSplitColumnNames: Output<List<String>>? = null

    private var featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null

    private var limitSettings: Output<TableVerticalLimitSettingsArgs>? = null

    private var logVerbosity: Output<Either<String, LogVerbosity>>? = null

    private var nCrossValidations:
        Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null

    private var positiveLabel: Output<String>? = null

    private var primaryMetric: Output<Either<String, ClassificationPrimaryMetrics>>? = null

    private var targetColumnName: Output<String>? = null

    private var taskType: Output<String>? = null

    private var testData: Output<MLTableJobInputArgs>? = null

    private var testDataSize: Output<Double>? = null

    private var trainingData: Output<MLTableJobInputArgs>? = null

    private var trainingSettings: Output<ClassificationTrainingSettingsArgs>? = null

    private var validationData: Output<MLTableJobInputArgs>? = null

    private var validationDataSize: Output<Double>? = null

    private var weightColumnName: Output<String>? = null

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("gagsloqgckyigmhu")
    public suspend fun cvSplitColumnNames(`value`: Output<List<String>>) {
        this.cvSplitColumnNames = value
    }

    @JvmName("gexddpfxqeeexdbm")
    public suspend fun cvSplitColumnNames(vararg values: Output<String>) {
        this.cvSplitColumnNames = Output.all(values.asList())
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("qddttbtifldcojqw")
    public suspend fun cvSplitColumnNames(values: List<Output<String>>) {
        this.cvSplitColumnNames = Output.all(values)
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("rktxfvrajqmhcdxt")
    public suspend
    fun featurizationSettings(`value`: Output<TableVerticalFeaturizationSettingsArgs>) {
        this.featurizationSettings = value
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("rvhlcxilhjuayjtr")
    public suspend fun limitSettings(`value`: Output<TableVerticalLimitSettingsArgs>) {
        this.limitSettings = value
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("waosiuitriwvnvfn")
    public suspend fun logVerbosity(`value`: Output<Either<String, LogVerbosity>>) {
        this.logVerbosity = value
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("sxgakkdjtvjnnmey")
    public suspend
    fun nCrossValidations(`value`: Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>) {
        this.nCrossValidations = value
    }

    /**
     * @param value Positive label for binary metrics calculation.
     */
    @JvmName("xyjsxnkfaeguabws")
    public suspend fun positiveLabel(`value`: Output<String>) {
        this.positiveLabel = value
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("vujqmsqgldwwpvcq")
    public suspend fun primaryMetric(`value`: Output<Either<String, ClassificationPrimaryMetrics>>) {
        this.primaryMetric = value
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("nfnxpddsngwjiwcd")
    public suspend fun targetColumnName(`value`: Output<String>) {
        this.targetColumnName = value
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Classification'.
     */
    @JvmName("togmbtihagcllqak")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Test data input.
     */
    @JvmName("tuweniadcgjblehe")
    public suspend fun testData(`value`: Output<MLTableJobInputArgs>) {
        this.testData = value
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("kpctblghbunsamed")
    public suspend fun testDataSize(`value`: Output<Double>) {
        this.testDataSize = value
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("rpwyuqpsjkkiuyjh")
    public suspend fun trainingData(`value`: Output<MLTableJobInputArgs>) {
        this.trainingData = value
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("ffswgjxjsddsgrac")
    public suspend fun trainingSettings(`value`: Output<ClassificationTrainingSettingsArgs>) {
        this.trainingSettings = value
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("cnbjatkixfoviwdr")
    public suspend fun validationData(`value`: Output<MLTableJobInputArgs>) {
        this.validationData = value
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("lgedjyxhydnsesib")
    public suspend fun validationDataSize(`value`: Output<Double>) {
        this.validationDataSize = value
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("jovymbdqdhtoavvf")
    public suspend fun weightColumnName(`value`: Output<String>) {
        this.weightColumnName = value
    }

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("ffrteklcyfhkwcaa")
    public suspend fun cvSplitColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("rrqbgefkvlwrxlon")
    public suspend fun cvSplitColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("fsnupgvoqyxijlmg")
    public suspend fun featurizationSettings(`value`: TableVerticalFeaturizationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featurizationSettings = mapped
    }

    /**
     * @param argument Featurization inputs needed for AutoML job.
     */
    @JvmName("wvjgaqxdidxfvrcj")
    public suspend
    fun featurizationSettings(argument: suspend TableVerticalFeaturizationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalFeaturizationSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featurizationSettings = mapped
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("bpbqpoutjvuyrlcg")
    public suspend fun limitSettings(`value`: TableVerticalLimitSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitSettings = mapped
    }

    /**
     * @param argument Execution constraints for AutoMLJob.
     */
    @JvmName("lgvsswwokfijgttw")
    public suspend
    fun limitSettings(argument: suspend TableVerticalLimitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalLimitSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limitSettings = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("evquxaxpgnugndcg")
    public suspend fun logVerbosity(`value`: Either<String, LogVerbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("ceecbhejogkgyhvk")
    public fun logVerbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("xjxojnyxnyciyxrj")
    public fun logVerbosity(`value`: LogVerbosity) {
        val toBeMapped = Either.ofRight<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("dwvxqfnshufbclys")
    public suspend
    fun nCrossValidations(`value`: Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("shvhaemdaxirvmrq")
    public fun nCrossValidations(`value`: AutoNCrossValidationsArgs) {
        val toBeMapped = Either.ofLeft<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("jfplcwqvkskpeqxh")
    public fun nCrossValidations(`value`: CustomNCrossValidationsArgs) {
        val toBeMapped = Either.ofRight<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Positive label for binary metrics calculation.
     */
    @JvmName("gmevoyvxlquptdeo")
    public suspend fun positiveLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.positiveLabel = mapped
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("bjyisytewwcxvjgk")
    public suspend fun primaryMetric(`value`: Either<String, ClassificationPrimaryMetrics>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("nhurjhqclsylagju")
    public fun primaryMetric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClassificationPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("okgmpeislkoxcvqv")
    public fun primaryMetric(`value`: ClassificationPrimaryMetrics) {
        val toBeMapped = Either.ofRight<String, ClassificationPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("hsldcrraidjxliyg")
    public suspend fun targetColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetColumnName = mapped
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Classification'.
     */
    @JvmName("bsxayqdxuybjlfks")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value Test data input.
     */
    @JvmName("snqjrvjidvtghicy")
    public suspend fun testData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testData = mapped
    }

    /**
     * @param argument Test data input.
     */
    @JvmName("hgrwoxaiqpcoaxkd")
    public suspend fun testData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.testData = mapped
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("nrleobqgucviifpg")
    public suspend fun testDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testDataSize = mapped
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("harvukvbrbeuoorj")
    public suspend fun trainingData(`value`: MLTableJobInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingData = mapped
    }

    /**
     * @param argument [Required] Training data input.
     */
    @JvmName("cihbiysccgppjtcx")
    public suspend fun trainingData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingData = mapped
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("hcvvawshahsxvriu")
    public suspend fun trainingSettings(`value`: ClassificationTrainingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingSettings = mapped
    }

    /**
     * @param argument Inputs for training phase for an AutoML Job.
     */
    @JvmName("ebimfwrplleqsrfx")
    public suspend
    fun trainingSettings(argument: suspend ClassificationTrainingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationTrainingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingSettings = mapped
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("uvppikvhqxrglbbk")
    public suspend fun validationData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param argument Validation data inputs.
     */
    @JvmName("xgjkypmodxcthcbo")
    public suspend fun validationData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationData = mapped
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("deyjvnqsptmpwwtu")
    public suspend fun validationDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationDataSize = mapped
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("nhxrwcsxloovkrhm")
    public suspend fun weightColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightColumnName = mapped
    }

    internal fun build(): ClassificationArgs = ClassificationArgs(
        cvSplitColumnNames = cvSplitColumnNames,
        featurizationSettings = featurizationSettings,
        limitSettings = limitSettings,
        logVerbosity = logVerbosity,
        nCrossValidations = nCrossValidations,
        positiveLabel = positiveLabel,
        primaryMetric = primaryMetric,
        targetColumnName = targetColumnName,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        testData = testData,
        testDataSize = testDataSize,
        trainingData = trainingData ?: throw PulumiNullFieldException("trainingData"),
        trainingSettings = trainingSettings,
        validationData = validationData,
        validationDataSize = validationDataSize,
        weightColumnName = weightColumnName,
    )
}
