@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ClassificationTrainingSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ClassificationModels
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Classification Training related configuration.
 * @property allowedTrainingAlgorithms Allowed models for classification task.
 * @property blockedTrainingAlgorithms Blocked models for classification task.
 * @property enableDnnTraining Enable recommendation of DNN models.
 * @property enableModelExplainability Flag to turn on explainability on best model.
 * @property enableOnnxCompatibleModels Flag for enabling onnx compatible models.
 * @property enableStackEnsemble Enable stack ensemble run.
 * @property enableVoteEnsemble Enable voting ensemble run.
 * @property ensembleModelDownloadTimeout During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
 * Configure this parameter with a higher value than 300 secs, if more time is needed.
 * @property stackEnsembleSettings Stack ensemble settings for stack ensemble run.
 */
public data class ClassificationTrainingSettingsArgs(
    public val allowedTrainingAlgorithms: Output<List<Either<String, ClassificationModels>>>? = null,
    public val blockedTrainingAlgorithms: Output<List<Either<String, ClassificationModels>>>? = null,
    public val enableDnnTraining: Output<Boolean>? = null,
    public val enableModelExplainability: Output<Boolean>? = null,
    public val enableOnnxCompatibleModels: Output<Boolean>? = null,
    public val enableStackEnsemble: Output<Boolean>? = null,
    public val enableVoteEnsemble: Output<Boolean>? = null,
    public val ensembleModelDownloadTimeout: Output<String>? = null,
    public val stackEnsembleSettings: Output<StackEnsembleSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ClassificationTrainingSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ClassificationTrainingSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ClassificationTrainingSettingsArgs.builder()
            .allowedTrainingAlgorithms(
                allowedTrainingAlgorithms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .blockedTrainingAlgorithms(
                blockedTrainingAlgorithms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .enableDnnTraining(enableDnnTraining?.applyValue({ args0 -> args0 }))
            .enableModelExplainability(enableModelExplainability?.applyValue({ args0 -> args0 }))
            .enableOnnxCompatibleModels(enableOnnxCompatibleModels?.applyValue({ args0 -> args0 }))
            .enableStackEnsemble(enableStackEnsemble?.applyValue({ args0 -> args0 }))
            .enableVoteEnsemble(enableVoteEnsemble?.applyValue({ args0 -> args0 }))
            .ensembleModelDownloadTimeout(ensembleModelDownloadTimeout?.applyValue({ args0 -> args0 }))
            .stackEnsembleSettings(
                stackEnsembleSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClassificationTrainingSettingsArgs].
 */
@PulumiTagMarker
public class ClassificationTrainingSettingsArgsBuilder internal constructor() {
    private var allowedTrainingAlgorithms: Output<List<Either<String, ClassificationModels>>>? = null

    private var blockedTrainingAlgorithms: Output<List<Either<String, ClassificationModels>>>? = null

    private var enableDnnTraining: Output<Boolean>? = null

    private var enableModelExplainability: Output<Boolean>? = null

    private var enableOnnxCompatibleModels: Output<Boolean>? = null

    private var enableStackEnsemble: Output<Boolean>? = null

    private var enableVoteEnsemble: Output<Boolean>? = null

    private var ensembleModelDownloadTimeout: Output<String>? = null

    private var stackEnsembleSettings: Output<StackEnsembleSettingsArgs>? = null

    /**
     * @param value Allowed models for classification task.
     */
    @JvmName("emkoopijjnmfqjvs")
    public suspend
    fun allowedTrainingAlgorithms(`value`: Output<List<Either<String, ClassificationModels>>>) {
        this.allowedTrainingAlgorithms = value
    }

    @JvmName("fqgdclucvdliajnv")
    public suspend fun allowedTrainingAlgorithms(
        vararg
        values: Output<Either<String, ClassificationModels>>,
    ) {
        this.allowedTrainingAlgorithms = Output.all(values.asList())
    }

    /**
     * @param values Allowed models for classification task.
     */
    @JvmName("jrpntuseiadoyovw")
    public suspend
    fun allowedTrainingAlgorithms(values: List<Output<Either<String, ClassificationModels>>>) {
        this.allowedTrainingAlgorithms = Output.all(values)
    }

    /**
     * @param value Blocked models for classification task.
     */
    @JvmName("foxlbcoimwoilahk")
    public suspend
    fun blockedTrainingAlgorithms(`value`: Output<List<Either<String, ClassificationModels>>>) {
        this.blockedTrainingAlgorithms = value
    }

    @JvmName("mofgiktvkiqaonrj")
    public suspend fun blockedTrainingAlgorithms(
        vararg
        values: Output<Either<String, ClassificationModels>>,
    ) {
        this.blockedTrainingAlgorithms = Output.all(values.asList())
    }

    /**
     * @param values Blocked models for classification task.
     */
    @JvmName("bmtygjmggdjminfy")
    public suspend
    fun blockedTrainingAlgorithms(values: List<Output<Either<String, ClassificationModels>>>) {
        this.blockedTrainingAlgorithms = Output.all(values)
    }

    /**
     * @param value Enable recommendation of DNN models.
     */
    @JvmName("kjqmttsxmihjrcpy")
    public suspend fun enableDnnTraining(`value`: Output<Boolean>) {
        this.enableDnnTraining = value
    }

    /**
     * @param value Flag to turn on explainability on best model.
     */
    @JvmName("ubdmbpsbptihpdhj")
    public suspend fun enableModelExplainability(`value`: Output<Boolean>) {
        this.enableModelExplainability = value
    }

    /**
     * @param value Flag for enabling onnx compatible models.
     */
    @JvmName("rdukhxmijrhuvqtt")
    public suspend fun enableOnnxCompatibleModels(`value`: Output<Boolean>) {
        this.enableOnnxCompatibleModels = value
    }

    /**
     * @param value Enable stack ensemble run.
     */
    @JvmName("aitokluhvkykdwbn")
    public suspend fun enableStackEnsemble(`value`: Output<Boolean>) {
        this.enableStackEnsemble = value
    }

    /**
     * @param value Enable voting ensemble run.
     */
    @JvmName("xhjsjpfbiowhnvhs")
    public suspend fun enableVoteEnsemble(`value`: Output<Boolean>) {
        this.enableVoteEnsemble = value
    }

    /**
     * @param value During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
     * Configure this parameter with a higher value than 300 secs, if more time is needed.
     */
    @JvmName("wnjytdymovtnnouw")
    public suspend fun ensembleModelDownloadTimeout(`value`: Output<String>) {
        this.ensembleModelDownloadTimeout = value
    }

    /**
     * @param value Stack ensemble settings for stack ensemble run.
     */
    @JvmName("kbquqeybrrrnwklk")
    public suspend fun stackEnsembleSettings(`value`: Output<StackEnsembleSettingsArgs>) {
        this.stackEnsembleSettings = value
    }

    /**
     * @param value Allowed models for classification task.
     */
    @JvmName("vjhbidlvhgqpkgyf")
    public suspend
    fun allowedTrainingAlgorithms(`value`: List<Either<String, ClassificationModels>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedTrainingAlgorithms = mapped
    }

    /**
     * @param values Allowed models for classification task.
     */
    @JvmName("ljjvwqdkvnpnaarp")
    public suspend fun allowedTrainingAlgorithms(
        vararg
        values: Either<String, ClassificationModels>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedTrainingAlgorithms = mapped
    }

    /**
     * @param value Blocked models for classification task.
     */
    @JvmName("ecvuthuosabgfisf")
    public suspend
    fun blockedTrainingAlgorithms(`value`: List<Either<String, ClassificationModels>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockedTrainingAlgorithms = mapped
    }

    /**
     * @param values Blocked models for classification task.
     */
    @JvmName("ldqbimbkiyudjoso")
    public suspend fun blockedTrainingAlgorithms(
        vararg
        values: Either<String, ClassificationModels>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockedTrainingAlgorithms = mapped
    }

    /**
     * @param value Enable recommendation of DNN models.
     */
    @JvmName("lkevvgvrybasnyqo")
    public suspend fun enableDnnTraining(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnnTraining = mapped
    }

    /**
     * @param value Flag to turn on explainability on best model.
     */
    @JvmName("ajbwjwhjbsejxdsj")
    public suspend fun enableModelExplainability(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableModelExplainability = mapped
    }

    /**
     * @param value Flag for enabling onnx compatible models.
     */
    @JvmName("ftwitysejqvqlquy")
    public suspend fun enableOnnxCompatibleModels(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnnxCompatibleModels = mapped
    }

    /**
     * @param value Enable stack ensemble run.
     */
    @JvmName("qgdfsmbxphxjcopx")
    public suspend fun enableStackEnsemble(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStackEnsemble = mapped
    }

    /**
     * @param value Enable voting ensemble run.
     */
    @JvmName("jekunlaegfifjrbx")
    public suspend fun enableVoteEnsemble(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVoteEnsemble = mapped
    }

    /**
     * @param value During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
     * Configure this parameter with a higher value than 300 secs, if more time is needed.
     */
    @JvmName("jlkdtlotpuwjrrjt")
    public suspend fun ensembleModelDownloadTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensembleModelDownloadTimeout = mapped
    }

    /**
     * @param value Stack ensemble settings for stack ensemble run.
     */
    @JvmName("qdwbnkbvspuiciqh")
    public suspend fun stackEnsembleSettings(`value`: StackEnsembleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackEnsembleSettings = mapped
    }

    /**
     * @param argument Stack ensemble settings for stack ensemble run.
     */
    @JvmName("cxrfjiafdeonyipe")
    public suspend
    fun stackEnsembleSettings(argument: suspend StackEnsembleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StackEnsembleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stackEnsembleSettings = mapped
    }

    internal fun build(): ClassificationTrainingSettingsArgs = ClassificationTrainingSettingsArgs(
        allowedTrainingAlgorithms = allowedTrainingAlgorithms,
        blockedTrainingAlgorithms = blockedTrainingAlgorithms,
        enableDnnTraining = enableDnnTraining,
        enableModelExplainability = enableModelExplainability,
        enableOnnxCompatibleModels = enableOnnxCompatibleModels,
        enableStackEnsemble = enableStackEnsemble,
        enableVoteEnsemble = enableVoteEnsemble,
        ensembleModelDownloadTimeout = ensembleModelDownloadTimeout,
        stackEnsembleSettings = stackEnsembleSettings,
    )
}
