@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CommandJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Command job definition.
 * @property codeId ARM resource ID of the code asset.
 * @property command [Required] The command to execute on startup of the job. eg. "python train.py"
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property distribution Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
 * @property environmentId [Required] The ARM resource ID of the Environment specification for the job.
 * @property environmentVariables Environment variables included in the job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property inputs Mapping of input data bindings used in the job.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Command'.
 * @property limits Command Job limit.
 * @property outputs Mapping of output data bindings used in the job.
 * @property properties The asset property dictionary.
 * @property resources Compute Resource configuration for the job.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class CommandJobArgs(
    public val codeId: Output<String>? = null,
    public val command: Output<String>,
    public val componentId: Output<String>? = null,
    public val computeId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val distribution: Output<Any>? = null,
    public val environmentId: Output<String>,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val experimentName: Output<String>? = null,
    public val identity: Output<Any>? = null,
    public val inputs: Output<Map<String, Any>>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val jobType: Output<String>,
    public val limits: Output<CommandJobLimitsArgs>? = null,
    public val outputs: Output<Map<String, Any>>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val resources: Output<JobResourceConfigurationArgs>? = null,
    public val services: Output<Map<String, JobServiceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CommandJobArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CommandJobArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CommandJobArgs.builder()
            .codeId(codeId?.applyValue({ args0 -> args0 }))
            .command(command.applyValue({ args0 -> args0 }))
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .computeId(computeId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .distribution(distribution?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0 }))
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .jobType(jobType.applyValue({ args0 -> args0 }))
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outputs(outputs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .services(
                services?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CommandJobArgs].
 */
@PulumiTagMarker
public class CommandJobArgsBuilder internal constructor() {
    private var codeId: Output<String>? = null

    private var command: Output<String>? = null

    private var componentId: Output<String>? = null

    private var computeId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var distribution: Output<Any>? = null

    private var environmentId: Output<String>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var experimentName: Output<String>? = null

    private var identity: Output<Any>? = null

    private var inputs: Output<Map<String, Any>>? = null

    private var isArchived: Output<Boolean>? = null

    private var jobType: Output<String>? = null

    private var limits: Output<CommandJobLimitsArgs>? = null

    private var outputs: Output<Map<String, Any>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var resources: Output<JobResourceConfigurationArgs>? = null

    private var services: Output<Map<String, JobServiceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ARM resource ID of the code asset.
     */
    @JvmName("mnuydiblpfudjytu")
    public suspend fun codeId(`value`: Output<String>) {
        this.codeId = value
    }

    /**
     * @param value [Required] The command to execute on startup of the job. eg. "python train.py"
     */
    @JvmName("rupsfpdlghqowbbs")
    public suspend fun command(`value`: Output<String>) {
        this.command = value
    }

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("ngghvvtjnykkqeac")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("phlabpsewhqluewe")
    public suspend fun computeId(`value`: Output<String>) {
        this.computeId = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("xfsfevvksokpfhll")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("amjeyfydvmaxfpli")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
     */
    @JvmName("vfsgnomqgdwstuqq")
    public suspend fun distribution(`value`: Output<Any>) {
        this.distribution = value
    }

    /**
     * @param value [Required] The ARM resource ID of the Environment specification for the job.
     */
    @JvmName("jgeccuixgkrbapln")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Environment variables included in the job.
     */
    @JvmName("opidduyomdevmjag")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("kkyvmwavhqqufixh")
    public suspend fun experimentName(`value`: Output<String>) {
        this.experimentName = value
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("ffadtxfhqmtismvi")
    public suspend fun identity(`value`: Output<Any>) {
        this.identity = value
    }

    /**
     * @param value Mapping of input data bindings used in the job.
     */
    @JvmName("rlcbrawqsfungpxw")
    public suspend fun inputs(`value`: Output<Map<String, Any>>) {
        this.inputs = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("yhgomyxbembomjdr")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Command'.
     */
    @JvmName("woeifmhgopoaxefj")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value Command Job limit.
     */
    @JvmName("wqrscunhqegpebjc")
    public suspend fun limits(`value`: Output<CommandJobLimitsArgs>) {
        this.limits = value
    }

    /**
     * @param value Mapping of output data bindings used in the job.
     */
    @JvmName("lunadaydrmfedkry")
    public suspend fun outputs(`value`: Output<Map<String, Any>>) {
        this.outputs = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("uwcjnypuosejjmwh")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Compute Resource configuration for the job.
     */
    @JvmName("idpvfbreaeuponln")
    public suspend fun resources(`value`: Output<JobResourceConfigurationArgs>) {
        this.resources = value
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("ucdlwxyoemqabofb")
    public suspend fun services(`value`: Output<Map<String, JobServiceArgs>>) {
        this.services = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ikwnxoichpfbudae")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARM resource ID of the code asset.
     */
    @JvmName("onqesrqvducjmvxi")
    public suspend fun codeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeId = mapped
    }

    /**
     * @param value [Required] The command to execute on startup of the job. eg. "python train.py"
     */
    @JvmName("uiftilmmdmbmlcjd")
    public suspend fun command(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("pyilnbgdnkjvvbat")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("wjgwnnvratkntwwf")
    public suspend fun computeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeId = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("sgxejiqjqrvdwxux")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("xdblpuhmyngbgolh")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
     */
    @JvmName("bjryslqqeiluoabt")
    public suspend fun distribution(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distribution = mapped
    }

    /**
     * @param value [Required] The ARM resource ID of the Environment specification for the job.
     */
    @JvmName("tsgegvqyngvhtjmc")
    public suspend fun environmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Environment variables included in the job.
     */
    @JvmName("yobiueogqvmdabgk")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables included in the job.
     */
    @JvmName("peegmyacathgusde")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("fvgftsfsorpmkaeb")
    public suspend fun experimentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("obcmaxoodiolmwmr")
    public suspend fun identity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Mapping of input data bindings used in the job.
     */
    @JvmName("mmbjgudsrdudekas")
    public suspend fun inputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param values Mapping of input data bindings used in the job.
     */
    @JvmName("dtubuathbsaroovm")
    public fun inputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("xysxmfepahebejyn")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Command'.
     */
    @JvmName("wuokdptbbitkptla")
    public suspend fun jobType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Command Job limit.
     */
    @JvmName("jhamonecrooqlupw")
    public suspend fun limits(`value`: CommandJobLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Command Job limit.
     */
    @JvmName("xgacqjofbywcilsk")
    public suspend fun limits(argument: suspend CommandJobLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = CommandJobLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Mapping of output data bindings used in the job.
     */
    @JvmName("rdrgnotcatddesvi")
    public suspend fun outputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param values Mapping of output data bindings used in the job.
     */
    @JvmName("kopalurfmyyidvrb")
    public fun outputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("yrruqcrkehrvamew")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("alnnuprpdafyccnk")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Compute Resource configuration for the job.
     */
    @JvmName("uqjpdcdohmvgrfqy")
    public suspend fun resources(`value`: JobResourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Compute Resource configuration for the job.
     */
    @JvmName("grdsqddcdelupxnj")
    public suspend fun resources(argument: suspend JobResourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = JobResourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("ylouxsxrasosicqv")
    public suspend fun services(`value`: Map<String, JobServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("relbtqrugjfofuig")
    public suspend fun services(
        vararg
        argument: Pair<String, suspend JobServiceArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                JobServiceArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param values List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("ghwuvpdiitiwwjbg")
    public fun services(vararg values: Pair<String, JobServiceArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("efeqdyoniqpfnuxl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("prbhxshbusibhfyp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CommandJobArgs = CommandJobArgs(
        codeId = codeId,
        command = command ?: throw PulumiNullFieldException("command"),
        componentId = componentId,
        computeId = computeId,
        description = description,
        displayName = displayName,
        distribution = distribution,
        environmentId = environmentId ?: throw PulumiNullFieldException("environmentId"),
        environmentVariables = environmentVariables,
        experimentName = experimentName,
        identity = identity,
        inputs = inputs,
        isArchived = isArchived,
        jobType = jobType ?: throw PulumiNullFieldException("jobType"),
        limits = limits,
        outputs = outputs,
        properties = properties,
        resources = resources,
        services = services,
        tags = tags,
    )
}
