@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ComputeStartStopScheduleArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ComputePowerAction
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ScheduleStatus
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.TriggerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Compute start stop schedule properties
 * @property action [Required] The compute power action.
 * @property cron Required if triggerType is Cron.
 * @property recurrence Required if triggerType is Recurrence.
 * @property schedule [Deprecated] Not used any more.
 * @property status Is the schedule enabled or disabled?
 * @property triggerType [Required] The schedule trigger type.
 */
public data class ComputeStartStopScheduleArgs(
    public val action: Output<Either<String, ComputePowerAction>>? = null,
    public val cron: Output<CronArgs>? = null,
    public val recurrence: Output<RecurrenceArgs>? = null,
    public val schedule: Output<ScheduleBaseArgs>? = null,
    public val status: Output<Either<String, ScheduleStatus>>? = null,
    public val triggerType: Output<Either<String, TriggerType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ComputeStartStopScheduleArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ComputeStartStopScheduleArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ComputeStartStopScheduleArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cron(cron?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recurrence(recurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .triggerType(
                triggerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ComputeStartStopScheduleArgs].
 */
@PulumiTagMarker
public class ComputeStartStopScheduleArgsBuilder internal constructor() {
    private var action: Output<Either<String, ComputePowerAction>>? = null

    private var cron: Output<CronArgs>? = null

    private var recurrence: Output<RecurrenceArgs>? = null

    private var schedule: Output<ScheduleBaseArgs>? = null

    private var status: Output<Either<String, ScheduleStatus>>? = null

    private var triggerType: Output<Either<String, TriggerType>>? = null

    /**
     * @param value [Required] The compute power action.
     */
    @JvmName("obphdqfgfclewbub")
    public suspend fun action(`value`: Output<Either<String, ComputePowerAction>>) {
        this.action = value
    }

    /**
     * @param value Required if triggerType is Cron.
     */
    @JvmName("uvxhlgydyenqblgc")
    public suspend fun cron(`value`: Output<CronArgs>) {
        this.cron = value
    }

    /**
     * @param value Required if triggerType is Recurrence.
     */
    @JvmName("vbposiwdtveebxoh")
    public suspend fun recurrence(`value`: Output<RecurrenceArgs>) {
        this.recurrence = value
    }

    /**
     * @param value [Deprecated] Not used any more.
     */
    @JvmName("qgpgbiirdawixmln")
    public suspend fun schedule(`value`: Output<ScheduleBaseArgs>) {
        this.schedule = value
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("mmoarvrysbplvosd")
    public suspend fun status(`value`: Output<Either<String, ScheduleStatus>>) {
        this.status = value
    }

    /**
     * @param value [Required] The schedule trigger type.
     */
    @JvmName("gbauecwwmqmmnbum")
    public suspend fun triggerType(`value`: Output<Either<String, TriggerType>>) {
        this.triggerType = value
    }

    /**
     * @param value [Required] The compute power action.
     */
    @JvmName("eufwjmowutxwbofw")
    public suspend fun action(`value`: Either<String, ComputePowerAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value [Required] The compute power action.
     */
    @JvmName("xsvgaooitwnakxqj")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ComputePowerAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value [Required] The compute power action.
     */
    @JvmName("bohavidtlkcqasvi")
    public fun action(`value`: ComputePowerAction) {
        val toBeMapped = Either.ofRight<String, ComputePowerAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Required if triggerType is Cron.
     */
    @JvmName("lawkmmqqqxbkguio")
    public suspend fun cron(`value`: CronArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cron = mapped
    }

    /**
     * @param argument Required if triggerType is Cron.
     */
    @JvmName("afoosfarrfmgjaab")
    public suspend fun cron(argument: suspend CronArgsBuilder.() -> Unit) {
        val toBeMapped = CronArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cron = mapped
    }

    /**
     * @param value Required if triggerType is Recurrence.
     */
    @JvmName("ecmbsoatwnlebrep")
    public suspend fun recurrence(`value`: RecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param argument Required if triggerType is Recurrence.
     */
    @JvmName("mewydkcffhlekvpm")
    public suspend fun recurrence(argument: suspend RecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrence = mapped
    }

    /**
     * @param value [Deprecated] Not used any more.
     */
    @JvmName("uqgbmpbdruhkahxd")
    public suspend fun schedule(`value`: ScheduleBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument [Deprecated] Not used any more.
     */
    @JvmName("cgrttxxqjegvvxtp")
    public suspend fun schedule(argument: suspend ScheduleBaseArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("sjccjhwbwskcrpey")
    public suspend fun status(`value`: Either<String, ScheduleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("rqkfewfrafardvwj")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("dyjmsdjfgaajtjjr")
    public fun status(`value`: ScheduleStatus) {
        val toBeMapped = Either.ofRight<String, ScheduleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value [Required] The schedule trigger type.
     */
    @JvmName("tqukdauihlcgxytt")
    public suspend fun triggerType(`value`: Either<String, TriggerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    /**
     * @param value [Required] The schedule trigger type.
     */
    @JvmName("cvythxkgoarocfym")
    public fun triggerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    /**
     * @param value [Required] The schedule trigger type.
     */
    @JvmName("nqquqvxhkjnxmens")
    public fun triggerType(`value`: TriggerType) {
        val toBeMapped = Either.ofRight<String, TriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): ComputeStartStopScheduleArgs = ComputeStartStopScheduleArgs(
        action = action,
        cron = cron,
        recurrence = recurrence,
        schedule = schedule,
        status = status,
        triggerType = triggerType,
    )
}
