@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ContentSafetyEndpointDeploymentResourcePropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.DeploymentModelVersionUpgradeOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property failureReason The failure reason if the creation failed.
 * @property model Model used for the endpoint deployment.
 * @property raiPolicyName The name of RAI policy.
 * @property sku
 * @property type Kind of the deployment.
 * Expected value is 'Azure.ContentSafety'.
 * @property versionUpgradeOption Deployment model version upgrade option.
 */
public data class ContentSafetyEndpointDeploymentResourcePropertiesArgs(
    public val failureReason: Output<String>? = null,
    public val model: Output<EndpointDeploymentModelArgs>,
    public val raiPolicyName: Output<String>? = null,
    public val sku: Output<CognitiveServicesSkuArgs>? = null,
    public val type: Output<String>,
    public val versionUpgradeOption: Output<Either<String, DeploymentModelVersionUpgradeOption>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ContentSafetyEndpointDeploymentResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ContentSafetyEndpointDeploymentResourcePropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ContentSafetyEndpointDeploymentResourcePropertiesArgs.builder()
            .failureReason(failureReason?.applyValue({ args0 -> args0 }))
            .model(model.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiPolicyName(raiPolicyName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .versionUpgradeOption(
                versionUpgradeOption?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ContentSafetyEndpointDeploymentResourcePropertiesArgs].
 */
@PulumiTagMarker
public class ContentSafetyEndpointDeploymentResourcePropertiesArgsBuilder internal constructor() {
    private var failureReason: Output<String>? = null

    private var model: Output<EndpointDeploymentModelArgs>? = null

    private var raiPolicyName: Output<String>? = null

    private var sku: Output<CognitiveServicesSkuArgs>? = null

    private var type: Output<String>? = null

    private var versionUpgradeOption: Output<Either<String, DeploymentModelVersionUpgradeOption>>? =
        null

    /**
     * @param value The failure reason if the creation failed.
     */
    @JvmName("npchylxnyjyqnpud")
    public suspend fun failureReason(`value`: Output<String>) {
        this.failureReason = value
    }

    /**
     * @param value Model used for the endpoint deployment.
     */
    @JvmName("cmadlhmgmjhgobks")
    public suspend fun model(`value`: Output<EndpointDeploymentModelArgs>) {
        this.model = value
    }

    /**
     * @param value The name of RAI policy.
     */
    @JvmName("keipnkmklafmmwvt")
    public suspend fun raiPolicyName(`value`: Output<String>) {
        this.raiPolicyName = value
    }

    /**
     * @param value
     */
    @JvmName("xporivvvlsbmkyuf")
    public suspend fun sku(`value`: Output<CognitiveServicesSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Kind of the deployment.
     * Expected value is 'Azure.ContentSafety'.
     */
    @JvmName("lpspyfqrystklgek")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("rdgmwomxxusfalka")
    public suspend
    fun versionUpgradeOption(`value`: Output<Either<String, DeploymentModelVersionUpgradeOption>>) {
        this.versionUpgradeOption = value
    }

    /**
     * @param value The failure reason if the creation failed.
     */
    @JvmName("pxqkpaseyraxbhvy")
    public suspend fun failureReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureReason = mapped
    }

    /**
     * @param value Model used for the endpoint deployment.
     */
    @JvmName("qbsjvplwoxkpmrey")
    public suspend fun model(`value`: EndpointDeploymentModelArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param argument Model used for the endpoint deployment.
     */
    @JvmName("ybltfsewrgfilawl")
    public suspend fun model(argument: suspend EndpointDeploymentModelArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointDeploymentModelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.model = mapped
    }

    /**
     * @param value The name of RAI policy.
     */
    @JvmName("doythfgcgrusdvoi")
    public suspend fun raiPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiPolicyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("qjuicuftdqlkqyke")
    public suspend fun sku(`value`: CognitiveServicesSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hlxyqnommqbsqcul")
    public suspend fun sku(argument: suspend CognitiveServicesSkuArgsBuilder.() -> Unit) {
        val toBeMapped = CognitiveServicesSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Kind of the deployment.
     * Expected value is 'Azure.ContentSafety'.
     */
    @JvmName("ekngqkofoiklmjnw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("cmlgtoqafpbkjbfh")
    public suspend
    fun versionUpgradeOption(`value`: Either<String, DeploymentModelVersionUpgradeOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionUpgradeOption = mapped
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("dfbsmqmywhjomddg")
    public fun versionUpgradeOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentModelVersionUpgradeOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versionUpgradeOption = mapped
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("rjrdvbvdbturqlix")
    public fun versionUpgradeOption(`value`: DeploymentModelVersionUpgradeOption) {
        val toBeMapped = Either.ofRight<String, DeploymentModelVersionUpgradeOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versionUpgradeOption = mapped
    }

    internal fun build(): ContentSafetyEndpointDeploymentResourcePropertiesArgs =
        ContentSafetyEndpointDeploymentResourcePropertiesArgs(
            failureReason = failureReason,
            model = model ?: throw PulumiNullFieldException("model"),
            raiPolicyName = raiPolicyName,
            sku = sku,
            type = type ?: throw PulumiNullFieldException("type"),
            versionUpgradeOption = versionUpgradeOption,
        )
}
