@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CronArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The workflow trigger cron for ComputeStartStop schedule type.
 * @property expression [Required] Specifies cron expression of schedule.
 * The expression should follow NCronTab format.
 * @property startTime The start time in yyyy-MM-ddTHH:mm:ss format.
 * @property timeZone Specifies time zone in which the schedule runs.
 * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
 */
public data class CronArgs(
    public val expression: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CronArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CronArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CronArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CronArgs].
 */
@PulumiTagMarker
public class CronArgsBuilder internal constructor() {
    private var expression: Output<String>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value [Required] Specifies cron expression of schedule.
     * The expression should follow NCronTab format.
     */
    @JvmName("dwdepwpaumkqncae")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value The start time in yyyy-MM-ddTHH:mm:ss format.
     */
    @JvmName("syvpfhqlkiolgktr")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("gvksbelbchvgsrrj")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value [Required] Specifies cron expression of schedule.
     * The expression should follow NCronTab format.
     */
    @JvmName("vakijaaolcshyssa")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value The start time in yyyy-MM-ddTHH:mm:ss format.
     */
    @JvmName("bhvfaavoqtkmgmrq")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("cwofhnsvxhegjbgu")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): CronArgs = CronArgs(
        expression = expression,
        startTime = startTime,
        timeZone = timeZone,
    )
}
