@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DataFactoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A DataFactory compute.
 * @property computeLocation Location for the underlying compute
 * @property computeType The type of compute
 * Expected value is 'DataFactory'.
 * @property description The description of the Machine Learning compute.
 * @property disableLocalAuth Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
 * @property resourceId ARM resource id of the underlying compute
 */
public data class DataFactoryArgs(
    public val computeLocation: Output<String>? = null,
    public val computeType: Output<String>,
    public val description: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DataFactoryArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.DataFactoryArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DataFactoryArgs.builder()
            .computeLocation(computeLocation?.applyValue({ args0 -> args0 }))
            .computeType(computeType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataFactoryArgs].
 */
@PulumiTagMarker
public class DataFactoryArgsBuilder internal constructor() {
    private var computeLocation: Output<String>? = null

    private var computeType: Output<String>? = null

    private var description: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Location for the underlying compute
     */
    @JvmName("ehjbohtdcklgcjtt")
    public suspend fun computeLocation(`value`: Output<String>) {
        this.computeLocation = value
    }

    /**
     * @param value The type of compute
     * Expected value is 'DataFactory'.
     */
    @JvmName("pyrtqkwefcwvbmkg")
    public suspend fun computeType(`value`: Output<String>) {
        this.computeType = value
    }

    /**
     * @param value The description of the Machine Learning compute.
     */
    @JvmName("gituehuxugiprpwy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
     */
    @JvmName("enauwctvucaubjbi")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value ARM resource id of the underlying compute
     */
    @JvmName("lvmyumygokkmacri")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Location for the underlying compute
     */
    @JvmName("lgqwipreodjbksep")
    public suspend fun computeLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeLocation = mapped
    }

    /**
     * @param value The type of compute
     * Expected value is 'DataFactory'.
     */
    @JvmName("vacbpadfbjfyotmd")
    public suspend fun computeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value The description of the Machine Learning compute.
     */
    @JvmName("fkwvpeindsumnsgr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
     */
    @JvmName("hewoflfsjxdgaqop")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value ARM resource id of the underlying compute
     */
    @JvmName("otmedsfrteixmphe")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): DataFactoryArgs = DataFactoryArgs(
        computeLocation = computeLocation,
        computeType = computeType ?: throw PulumiNullFieldException("computeType"),
        description = description,
        disableLocalAuth = disableLocalAuth,
        resourceId = resourceId,
    )
}
