@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DockerBuildArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class to represent configuration settings for Docker Build
 * @property context Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
 * The path is relative to the asset path which must contain a single Blob URI value.
 * <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
 * @property dockerSpecificationType Enum to determine docker specification type. Must be either Build or Image.
 * Expected value is 'Build'.
 * @property dockerfile [Required] Docker command line instructions to assemble an image.
 * <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
 * @property platform The platform information of the docker image.
 */
public data class DockerBuildArgs(
    public val context: Output<String>? = null,
    public val dockerSpecificationType: Output<String>,
    public val dockerfile: Output<String>,
    public val platform: Output<DockerImagePlatformArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DockerBuildArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.DockerBuildArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DockerBuildArgs.builder()
            .context(context?.applyValue({ args0 -> args0 }))
            .dockerSpecificationType(dockerSpecificationType.applyValue({ args0 -> args0 }))
            .dockerfile(dockerfile.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DockerBuildArgs].
 */
@PulumiTagMarker
public class DockerBuildArgsBuilder internal constructor() {
    private var context: Output<String>? = null

    private var dockerSpecificationType: Output<String>? = null

    private var dockerfile: Output<String>? = null

    private var platform: Output<DockerImagePlatformArgs>? = null

    /**
     * @param value Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
     * The path is relative to the asset path which must contain a single Blob URI value.
     * <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
     */
    @JvmName("vrvnvninvaghjxex")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value Enum to determine docker specification type. Must be either Build or Image.
     * Expected value is 'Build'.
     */
    @JvmName("biwfmyqfvnetmctr")
    public suspend fun dockerSpecificationType(`value`: Output<String>) {
        this.dockerSpecificationType = value
    }

    /**
     * @param value [Required] Docker command line instructions to assemble an image.
     * <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
     */
    @JvmName("mxhiesrktnqsyaam")
    public suspend fun dockerfile(`value`: Output<String>) {
        this.dockerfile = value
    }

    /**
     * @param value The platform information of the docker image.
     */
    @JvmName("jldqpxqxdbsjuuep")
    public suspend fun platform(`value`: Output<DockerImagePlatformArgs>) {
        this.platform = value
    }

    /**
     * @param value Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
     * The path is relative to the asset path which must contain a single Blob URI value.
     * <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
     */
    @JvmName("vknbpcbpapweqjkj")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value Enum to determine docker specification type. Must be either Build or Image.
     * Expected value is 'Build'.
     */
    @JvmName("pipmxcxqxxmobysa")
    public suspend fun dockerSpecificationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerSpecificationType = mapped
    }

    /**
     * @param value [Required] Docker command line instructions to assemble an image.
     * <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
     */
    @JvmName("tnbwynwurdufogoh")
    public suspend fun dockerfile(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerfile = mapped
    }

    /**
     * @param value The platform information of the docker image.
     */
    @JvmName("xmvageevafjcwojc")
    public suspend fun platform(`value`: DockerImagePlatformArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The platform information of the docker image.
     */
    @JvmName("fmmkavstneapfeqh")
    public suspend fun platform(argument: suspend DockerImagePlatformArgsBuilder.() -> Unit) {
        val toBeMapped = DockerImagePlatformArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    internal fun build(): DockerBuildArgs = DockerBuildArgs(
        context = context,
        dockerSpecificationType = dockerSpecificationType ?: throw
            PulumiNullFieldException("dockerSpecificationType"),
        dockerfile = dockerfile ?: throw PulumiNullFieldException("dockerfile"),
        platform = platform,
    )
}
