@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DockerImagePlatformArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.OperatingSystemType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property operatingSystemType The OS type the Environment.
 */
public data class DockerImagePlatformArgs(
    public val operatingSystemType: Output<Either<String, OperatingSystemType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DockerImagePlatformArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DockerImagePlatformArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DockerImagePlatformArgs.builder()
            .operatingSystemType(
                operatingSystemType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [DockerImagePlatformArgs].
 */
@PulumiTagMarker
public class DockerImagePlatformArgsBuilder internal constructor() {
    private var operatingSystemType: Output<Either<String, OperatingSystemType>>? = null

    /**
     * @param value The OS type the Environment.
     */
    @JvmName("dxkmvbjujbbpsqku")
    public suspend fun operatingSystemType(`value`: Output<Either<String, OperatingSystemType>>) {
        this.operatingSystemType = value
    }

    /**
     * @param value The OS type the Environment.
     */
    @JvmName("vfthnqowmbsttyis")
    public suspend fun operatingSystemType(`value`: Either<String, OperatingSystemType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystemType = mapped
    }

    /**
     * @param value The OS type the Environment.
     */
    @JvmName("jcaypchtfuqioeid")
    public fun operatingSystemType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingSystemType = mapped
    }

    /**
     * @param value The OS type the Environment.
     */
    @JvmName("xoltbhucuojbjkdm")
    public fun operatingSystemType(`value`: OperatingSystemType) {
        val toBeMapped = Either.ofRight<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingSystemType = mapped
    }

    internal fun build(): DockerImagePlatformArgs = DockerImagePlatformArgs(
        operatingSystemType = operatingSystemType,
    )
}
