@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EncryptionPropertyArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.EncryptionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property identity The identity that will be used to access the key vault for encryption at rest.
 * @property keyVaultProperties Customer Key vault properties.
 * @property status Indicates whether or not the encryption is enabled for the workspace.
 */
public data class EncryptionPropertyArgs(
    public val identity: Output<IdentityForCmkArgs>? = null,
    public val keyVaultProperties: Output<EncryptionKeyVaultPropertiesArgs>,
    public val status: Output<Either<String, EncryptionStatus>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EncryptionPropertyArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.EncryptionPropertyArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EncryptionPropertyArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultProperties(
                keyVaultProperties.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertyArgs].
 */
@PulumiTagMarker
public class EncryptionPropertyArgsBuilder internal constructor() {
    private var identity: Output<IdentityForCmkArgs>? = null

    private var keyVaultProperties: Output<EncryptionKeyVaultPropertiesArgs>? = null

    private var status: Output<Either<String, EncryptionStatus>>? = null

    /**
     * @param value The identity that will be used to access the key vault for encryption at rest.
     */
    @JvmName("foeavfrgrluanfvf")
    public suspend fun identity(`value`: Output<IdentityForCmkArgs>) {
        this.identity = value
    }

    /**
     * @param value Customer Key vault properties.
     */
    @JvmName("sksmawmeuvhtpfml")
    public suspend fun keyVaultProperties(`value`: Output<EncryptionKeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for the workspace.
     */
    @JvmName("iafkmpaseyakdsuv")
    public suspend fun status(`value`: Output<Either<String, EncryptionStatus>>) {
        this.status = value
    }

    /**
     * @param value The identity that will be used to access the key vault for encryption at rest.
     */
    @JvmName("hlghjvvxdjgklvdl")
    public suspend fun identity(`value`: IdentityForCmkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity that will be used to access the key vault for encryption at rest.
     */
    @JvmName("thqkapdscllykgoh")
    public suspend fun identity(argument: suspend IdentityForCmkArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityForCmkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Customer Key vault properties.
     */
    @JvmName("xmkbxdvnodywhpdv")
    public suspend fun keyVaultProperties(`value`: EncryptionKeyVaultPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Customer Key vault properties.
     */
    @JvmName("crdjqkrnmdjcphkb")
    public suspend
    fun keyVaultProperties(argument: suspend EncryptionKeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionKeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for the workspace.
     */
    @JvmName("lkjehfnburmayaea")
    public suspend fun status(`value`: Either<String, EncryptionStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for the workspace.
     */
    @JvmName("mvfuuaycquvqoeuu")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for the workspace.
     */
    @JvmName("jekctgcywqqydrpv")
    public fun status(`value`: EncryptionStatus) {
        val toBeMapped = Either.ofRight<String, EncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): EncryptionPropertyArgs = EncryptionPropertyArgs(
        identity = identity,
        keyVaultProperties = keyVaultProperties ?: throw PulumiNullFieldException("keyVaultProperties"),
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
