@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EndpointArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.Protocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the endpoint configuration for the container
 * @property hostIp Host IP over which the application is exposed from the container
 * @property name Name of the Endpoint
 * @property protocol Protocol over which communication will happen over this endpoint
 * @property published Port over which the application is exposed from container.
 * @property target Application port inside the container.
 */
public data class EndpointArgs(
    public val hostIp: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, Protocol>>? = null,
    public val published: Output<Int>? = null,
    public val target: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.EndpointArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EndpointArgs.builder()
            .hostIp(hostIp?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .published(published?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var hostIp: Output<String>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, Protocol>>? = null

    private var published: Output<Int>? = null

    private var target: Output<Int>? = null

    /**
     * @param value Host IP over which the application is exposed from the container
     */
    @JvmName("mfyvipclwvlngwik")
    public suspend fun hostIp(`value`: Output<String>) {
        this.hostIp = value
    }

    /**
     * @param value Name of the Endpoint
     */
    @JvmName("dqgwfscikovhygpr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Protocol over which communication will happen over this endpoint
     */
    @JvmName("aswhprrnrhhwgudt")
    public suspend fun protocol(`value`: Output<Either<String, Protocol>>) {
        this.protocol = value
    }

    /**
     * @param value Port over which the application is exposed from container.
     */
    @JvmName("fclcrirnchudpdnx")
    public suspend fun published(`value`: Output<Int>) {
        this.published = value
    }

    /**
     * @param value Application port inside the container.
     */
    @JvmName("fuafcqqclslbhwvt")
    public suspend fun target(`value`: Output<Int>) {
        this.target = value
    }

    /**
     * @param value Host IP over which the application is exposed from the container
     */
    @JvmName("ukjsjjqpfhfqggos")
    public suspend fun hostIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostIp = mapped
    }

    /**
     * @param value Name of the Endpoint
     */
    @JvmName("jyhdfrwvmnwqrmts")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Protocol over which communication will happen over this endpoint
     */
    @JvmName("ymogopyhybmoiail")
    public suspend fun protocol(`value`: Either<String, Protocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol over which communication will happen over this endpoint
     */
    @JvmName("gbnplcirotkatyxc")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol over which communication will happen over this endpoint
     */
    @JvmName("vwyglogbfpnxvjab")
    public fun protocol(`value`: Protocol) {
        val toBeMapped = Either.ofRight<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Port over which the application is exposed from container.
     */
    @JvmName("ijutwuktvpctepde")
    public suspend fun published(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.published = mapped
    }

    /**
     * @param value Application port inside the container.
     */
    @JvmName("gfcgqbloxefxgeto")
    public suspend fun target(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        hostIp = hostIp,
        name = name,
        protocol = protocol,
        published = published,
        target = target,
    )
}
