@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentSpecificationVersionArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Environment specification version details.
 * <see href="https://repo2docker.readthedocs.io/en/latest/specification.html" />
 * @property condaFile Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
 * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
 * @property description The asset description text.
 * @property docker Configuration settings for Docker.
 * @property inferenceContainerProperties Defines configuration specific to inference.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class EnvironmentSpecificationVersionArgs(
    public val condaFile: Output<String>? = null,
    public val description: Output<String>? = null,
    public val docker: Output<Either<DockerBuildArgs, DockerImageArgs>>? = null,
    public val inferenceContainerProperties: Output<InferenceContainerPropertiesArgs>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentSpecificationVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentSpecificationVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentSpecificationVersionArgs.builder()
            .condaFile(condaFile?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .docker(
                docker?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .inferenceContainerProperties(
                inferenceContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnvironmentSpecificationVersionArgs].
 */
@PulumiTagMarker
public class EnvironmentSpecificationVersionArgsBuilder internal constructor() {
    private var condaFile: Output<String>? = null

    private var description: Output<String>? = null

    private var docker: Output<Either<DockerBuildArgs, DockerImageArgs>>? = null

    private var inferenceContainerProperties: Output<InferenceContainerPropertiesArgs>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
     * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
     */
    @JvmName("kxoqrmpfkukwrbpr")
    public suspend fun condaFile(`value`: Output<String>) {
        this.condaFile = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("veyrolbyipivnoyy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Configuration settings for Docker.
     */
    @JvmName("dtllxdarabieohig")
    public suspend fun docker(`value`: Output<Either<DockerBuildArgs, DockerImageArgs>>) {
        this.docker = value
    }

    /**
     * @param value Defines configuration specific to inference.
     */
    @JvmName("jphhirckymjwihba")
    public suspend
    fun inferenceContainerProperties(`value`: Output<InferenceContainerPropertiesArgs>) {
        this.inferenceContainerProperties = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("mgghkcahwmmqmodl")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("gxowvqhgtysmkbea")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ksbegxniaxxhskav")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
     * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
     */
    @JvmName("gogqfkkbtnhpevmf")
    public suspend fun condaFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condaFile = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("mvvudoayynwxeajo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Configuration settings for Docker.
     */
    @JvmName("fcgqtouofvwlfwpk")
    public suspend fun docker(`value`: Either<DockerBuildArgs, DockerImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.docker = mapped
    }

    /**
     * @param value Configuration settings for Docker.
     */
    @JvmName("nahjvhbsvlwtpqwe")
    public fun docker(`value`: DockerBuildArgs) {
        val toBeMapped = Either.ofLeft<DockerBuildArgs, DockerImageArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.docker = mapped
    }

    /**
     * @param value Configuration settings for Docker.
     */
    @JvmName("rcpvlvpdbqqfsyxn")
    public fun docker(`value`: DockerImageArgs) {
        val toBeMapped = Either.ofRight<DockerBuildArgs, DockerImageArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.docker = mapped
    }

    /**
     * @param value Defines configuration specific to inference.
     */
    @JvmName("girddduxmelgxnhw")
    public suspend fun inferenceContainerProperties(`value`: InferenceContainerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceContainerProperties = mapped
    }

    /**
     * @param argument Defines configuration specific to inference.
     */
    @JvmName("fhjowomuitjrexna")
    public suspend
    fun inferenceContainerProperties(argument: suspend InferenceContainerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = InferenceContainerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inferenceContainerProperties = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("jmkdfmmuryknoigg")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("frnqgyabplspkyva")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("qhffvtvscpodqcub")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ueobpmhjkpfqklpq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("fxoyngjpwxwivdnk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnvironmentSpecificationVersionArgs = EnvironmentSpecificationVersionArgs(
        condaFile = condaFile,
        description = description,
        docker = docker,
        inferenceContainerProperties = inferenceContainerProperties,
        isAnonymous = isAnonymous,
        properties = properties,
        tags = tags,
    )
}
