@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVersionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.AutoRebuildSetting
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.OperatingSystemType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Environment version details.
 * @property autoRebuild Defines if image needs to be rebuilt based on base image changes.
 * @property build Configuration settings for Docker build context.
 * @property condaFile Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
 * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
 * @property description The asset description text.
 * @property image Name of the image that will be used for the environment.
 * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
 * @property inferenceConfig Defines configuration specific to inference.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property osType The OS type of the environment.
 * @property properties The asset property dictionary.
 * @property stage Stage in the environment lifecycle assigned to this environment
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class EnvironmentVersionArgs(
    public val autoRebuild: Output<Either<String, AutoRebuildSetting>>? = null,
    public val build: Output<BuildContextArgs>? = null,
    public val condaFile: Output<String>? = null,
    public val description: Output<String>? = null,
    public val image: Output<String>? = null,
    public val inferenceConfig: Output<InferenceContainerPropertiesArgs>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val osType: Output<Either<String, OperatingSystemType>>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val stage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVersionArgs.builder()
            .autoRebuild(
                autoRebuild?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .build(build?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .condaFile(condaFile?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0 }))
            .inferenceConfig(inferenceConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .stage(stage?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnvironmentVersionArgs].
 */
@PulumiTagMarker
public class EnvironmentVersionArgsBuilder internal constructor() {
    private var autoRebuild: Output<Either<String, AutoRebuildSetting>>? = null

    private var build: Output<BuildContextArgs>? = null

    private var condaFile: Output<String>? = null

    private var description: Output<String>? = null

    private var image: Output<String>? = null

    private var inferenceConfig: Output<InferenceContainerPropertiesArgs>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var osType: Output<Either<String, OperatingSystemType>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var stage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Defines if image needs to be rebuilt based on base image changes.
     */
    @JvmName("iktvtkymoaeqmxxi")
    public suspend fun autoRebuild(`value`: Output<Either<String, AutoRebuildSetting>>) {
        this.autoRebuild = value
    }

    /**
     * @param value Configuration settings for Docker build context.
     */
    @JvmName("sdsrtsnmqxfognbp")
    public suspend fun build(`value`: Output<BuildContextArgs>) {
        this.build = value
    }

    /**
     * @param value Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
     * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
     */
    @JvmName("epkmubjjqkrssfxn")
    public suspend fun condaFile(`value`: Output<String>) {
        this.condaFile = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("iolgmmbxuwemyysk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the image that will be used for the environment.
     * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
     */
    @JvmName("jlwcgxetqljguywd")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Defines configuration specific to inference.
     */
    @JvmName("avelafmloecunfgp")
    public suspend fun inferenceConfig(`value`: Output<InferenceContainerPropertiesArgs>) {
        this.inferenceConfig = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("mbejdkkdvoanhxvh")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("ftkfbqlwfinjdvfx")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The OS type of the environment.
     */
    @JvmName("yxyfayonerhnncip")
    public suspend fun osType(`value`: Output<Either<String, OperatingSystemType>>) {
        this.osType = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("lqxmuexgtuwlctig")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Stage in the environment lifecycle assigned to this environment
     */
    @JvmName("wdfblhkhvejjdhro")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("cioigxkxlcldedmb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines if image needs to be rebuilt based on base image changes.
     */
    @JvmName("dnvslhlgjavledhe")
    public suspend fun autoRebuild(`value`: Either<String, AutoRebuildSetting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRebuild = mapped
    }

    /**
     * @param value Defines if image needs to be rebuilt based on base image changes.
     */
    @JvmName("qpfyhswmwkwyieem")
    public fun autoRebuild(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoRebuildSetting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoRebuild = mapped
    }

    /**
     * @param value Defines if image needs to be rebuilt based on base image changes.
     */
    @JvmName("qklhxkllsablgrqn")
    public fun autoRebuild(`value`: AutoRebuildSetting) {
        val toBeMapped = Either.ofRight<String, AutoRebuildSetting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoRebuild = mapped
    }

    /**
     * @param value Configuration settings for Docker build context.
     */
    @JvmName("vpsjxnlmkaxknoeo")
    public suspend fun build(`value`: BuildContextArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.build = mapped
    }

    /**
     * @param argument Configuration settings for Docker build context.
     */
    @JvmName("rfjthhaglmjccnil")
    public suspend fun build(argument: suspend BuildContextArgsBuilder.() -> Unit) {
        val toBeMapped = BuildContextArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.build = mapped
    }

    /**
     * @param value Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
     * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
     */
    @JvmName("wihdfqokewepouoc")
    public suspend fun condaFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condaFile = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("wcbjjbhnrywqqyof")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the image that will be used for the environment.
     * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
     */
    @JvmName("vkcyslbmmcnngwmx")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Defines configuration specific to inference.
     */
    @JvmName("rvmamdwdrprovkyq")
    public suspend fun inferenceConfig(`value`: InferenceContainerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceConfig = mapped
    }

    /**
     * @param argument Defines configuration specific to inference.
     */
    @JvmName("hcngulushculrpum")
    public suspend
    fun inferenceConfig(argument: suspend InferenceContainerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = InferenceContainerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inferenceConfig = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("hjcqwlkitdflksef")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("mgbofqcyvoqvayht")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The OS type of the environment.
     */
    @JvmName("yeraoqyyjgqppylx")
    public suspend fun osType(`value`: Either<String, OperatingSystemType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The OS type of the environment.
     */
    @JvmName("wjshebhmmojsxoas")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The OS type of the environment.
     */
    @JvmName("iptmbdbcbegyyujk")
    public fun osType(`value`: OperatingSystemType) {
        val toBeMapped = Either.ofRight<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("surmwlisgxwyewpp")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("ufwtxvyoeaqivscd")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Stage in the environment lifecycle assigned to this environment
     */
    @JvmName("duonjnuasscfeocs")
    public suspend fun stage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("reotvubhrlwqumvl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("hxbfcrxjvaarptno")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnvironmentVersionArgs = EnvironmentVersionArgs(
        autoRebuild = autoRebuild,
        build = build,
        condaFile = condaFile,
        description = description,
        image = image,
        inferenceConfig = inferenceConfig,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        osType = osType,
        properties = properties,
        stage = stage,
        tags = tags,
    )
}
