@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ForecastingSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.FeatureLags
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ShortSeriesHandlingConfiguration
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.TargetAggregationFunction
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.UseStl
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Forecasting specific parameters.
 * @property countryOrRegionForHolidays Country or region for holidays for forecasting tasks.
 * These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
 * @property cvStepSize Number of periods between the origin time of one CV fold and the next fold. For
 * example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
 * three days apart.
 * @property featureLags Flag for generating lags for the numeric features with 'auto' or null.
 * @property forecastHorizon The desired maximum forecast horizon in units of time-series frequency.
 * @property frequency When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
 * @property seasonality Set time series seasonality as an integer multiple of the series frequency.
 * If seasonality is set to 'auto', it will be inferred.
 * @property shortSeriesHandlingConfig The parameter defining how if AutoML should handle short time series.
 * @property targetAggregateFunction The function to be used to aggregate the time series target column to conform to a user specified frequency.
 * If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
 * @property targetLags The number of past periods to lag from the target column.
 * @property targetRollingWindowSize The number of past periods used to create a rolling window average of the target column.
 * @property timeColumnName The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
 * @property timeSeriesIdColumnNames The names of columns used to group a timeseries. It can be used to create multiple series.
 * If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
 * @property useStl Configure STL Decomposition of the time-series target column.
 */
public data class ForecastingSettingsArgs(
    public val countryOrRegionForHolidays: Output<String>? = null,
    public val cvStepSize: Output<Int>? = null,
    public val featureLags: Output<Either<String, FeatureLags>>? = null,
    public val forecastHorizon: Output<Either<AutoForecastHorizonArgs, CustomForecastHorizonArgs>>? =
        null,
    public val frequency: Output<String>? = null,
    public val seasonality: Output<Either<AutoSeasonalityArgs, CustomSeasonalityArgs>>? = null,
    public val shortSeriesHandlingConfig: Output<Either<String, ShortSeriesHandlingConfiguration>>? =
        null,
    public val targetAggregateFunction: Output<Either<String, TargetAggregationFunction>>? = null,
    public val targetLags: Output<Either<AutoTargetLagsArgs, CustomTargetLagsArgs>>? = null,
    public val targetRollingWindowSize:
    Output<Either<AutoTargetRollingWindowSizeArgs, CustomTargetRollingWindowSizeArgs>>? = null,
    public val timeColumnName: Output<String>? = null,
    public val timeSeriesIdColumnNames: Output<List<String>>? = null,
    public val useStl: Output<Either<String, UseStl>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ForecastingSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ForecastingSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ForecastingSettingsArgs.builder()
            .countryOrRegionForHolidays(countryOrRegionForHolidays?.applyValue({ args0 -> args0 }))
            .cvStepSize(cvStepSize?.applyValue({ args0 -> args0 }))
            .featureLags(
                featureLags?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .forecastHorizon(
                forecastHorizon?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .frequency(frequency?.applyValue({ args0 -> args0 }))
            .seasonality(
                seasonality?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .shortSeriesHandlingConfig(
                shortSeriesHandlingConfig?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetAggregateFunction(
                targetAggregateFunction?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetLags(
                targetLags?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetRollingWindowSize(
                targetRollingWindowSize?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .timeColumnName(timeColumnName?.applyValue({ args0 -> args0 }))
            .timeSeriesIdColumnNames(
                timeSeriesIdColumnNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .useStl(
                useStl?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ForecastingSettingsArgs].
 */
@PulumiTagMarker
public class ForecastingSettingsArgsBuilder internal constructor() {
    private var countryOrRegionForHolidays: Output<String>? = null

    private var cvStepSize: Output<Int>? = null

    private var featureLags: Output<Either<String, FeatureLags>>? = null

    private var forecastHorizon: Output<Either<AutoForecastHorizonArgs, CustomForecastHorizonArgs>>? =
        null

    private var frequency: Output<String>? = null

    private var seasonality: Output<Either<AutoSeasonalityArgs, CustomSeasonalityArgs>>? = null

    private var shortSeriesHandlingConfig: Output<Either<String, ShortSeriesHandlingConfiguration>>? =
        null

    private var targetAggregateFunction: Output<Either<String, TargetAggregationFunction>>? = null

    private var targetLags: Output<Either<AutoTargetLagsArgs, CustomTargetLagsArgs>>? = null

    private var targetRollingWindowSize:
        Output<Either<AutoTargetRollingWindowSizeArgs, CustomTargetRollingWindowSizeArgs>>? = null

    private var timeColumnName: Output<String>? = null

    private var timeSeriesIdColumnNames: Output<List<String>>? = null

    private var useStl: Output<Either<String, UseStl>>? = null

    /**
     * @param value Country or region for holidays for forecasting tasks.
     * These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
     */
    @JvmName("tgbfavwtxsqqkfnd")
    public suspend fun countryOrRegionForHolidays(`value`: Output<String>) {
        this.countryOrRegionForHolidays = value
    }

    /**
     * @param value Number of periods between the origin time of one CV fold and the next fold. For
     * example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
     * three days apart.
     */
    @JvmName("tkkdrvymbgvdkhvd")
    public suspend fun cvStepSize(`value`: Output<Int>) {
        this.cvStepSize = value
    }

    /**
     * @param value Flag for generating lags for the numeric features with 'auto' or null.
     */
    @JvmName("pnkjiowtjbssloru")
    public suspend fun featureLags(`value`: Output<Either<String, FeatureLags>>) {
        this.featureLags = value
    }

    /**
     * @param value The desired maximum forecast horizon in units of time-series frequency.
     */
    @JvmName("cirxfarkvkygtgkp")
    public suspend
    fun forecastHorizon(`value`: Output<Either<AutoForecastHorizonArgs, CustomForecastHorizonArgs>>) {
        this.forecastHorizon = value
    }

    /**
     * @param value When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
     */
    @JvmName("vjmksuocpfqxfwaw")
    public suspend fun frequency(`value`: Output<String>) {
        this.frequency = value
    }

    /**
     * @param value Set time series seasonality as an integer multiple of the series frequency.
     * If seasonality is set to 'auto', it will be inferred.
     */
    @JvmName("gidndclidlitradk")
    public suspend
    fun seasonality(`value`: Output<Either<AutoSeasonalityArgs, CustomSeasonalityArgs>>) {
        this.seasonality = value
    }

    /**
     * @param value The parameter defining how if AutoML should handle short time series.
     */
    @JvmName("jjbemvfjfgnwllww")
    public suspend
    fun shortSeriesHandlingConfig(`value`: Output<Either<String, ShortSeriesHandlingConfiguration>>) {
        this.shortSeriesHandlingConfig = value
    }

    /**
     * @param value The function to be used to aggregate the time series target column to conform to a user specified frequency.
     * If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     */
    @JvmName("qjdvileyfafuabnw")
    public suspend
    fun targetAggregateFunction(`value`: Output<Either<String, TargetAggregationFunction>>) {
        this.targetAggregateFunction = value
    }

    /**
     * @param value The number of past periods to lag from the target column.
     */
    @JvmName("pxrxwquyfucduuun")
    public suspend fun targetLags(`value`: Output<Either<AutoTargetLagsArgs, CustomTargetLagsArgs>>) {
        this.targetLags = value
    }

    /**
     * @param value The number of past periods used to create a rolling window average of the target column.
     */
    @JvmName("qwuovjnhtnethpwh")
    public suspend
    fun targetRollingWindowSize(`value`: Output<Either<AutoTargetRollingWindowSizeArgs, CustomTargetRollingWindowSizeArgs>>) {
        this.targetRollingWindowSize = value
    }

    /**
     * @param value The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
     */
    @JvmName("ffidhwpfqmisslkd")
    public suspend fun timeColumnName(`value`: Output<String>) {
        this.timeColumnName = value
    }

    /**
     * @param value The names of columns used to group a timeseries. It can be used to create multiple series.
     * If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
     */
    @JvmName("ayydsrovccxkgyvx")
    public suspend fun timeSeriesIdColumnNames(`value`: Output<List<String>>) {
        this.timeSeriesIdColumnNames = value
    }

    @JvmName("foquhfegnntqqhwg")
    public suspend fun timeSeriesIdColumnNames(vararg values: Output<String>) {
        this.timeSeriesIdColumnNames = Output.all(values.asList())
    }

    /**
     * @param values The names of columns used to group a timeseries. It can be used to create multiple series.
     * If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
     */
    @JvmName("lfiiwjmkkorulqyx")
    public suspend fun timeSeriesIdColumnNames(values: List<Output<String>>) {
        this.timeSeriesIdColumnNames = Output.all(values)
    }

    /**
     * @param value Configure STL Decomposition of the time-series target column.
     */
    @JvmName("xpqnnaqitcdldyab")
    public suspend fun useStl(`value`: Output<Either<String, UseStl>>) {
        this.useStl = value
    }

    /**
     * @param value Country or region for holidays for forecasting tasks.
     * These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
     */
    @JvmName("hnueiskeodligvdm")
    public suspend fun countryOrRegionForHolidays(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryOrRegionForHolidays = mapped
    }

    /**
     * @param value Number of periods between the origin time of one CV fold and the next fold. For
     * example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
     * three days apart.
     */
    @JvmName("huiexejmihvgbyxv")
    public suspend fun cvStepSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cvStepSize = mapped
    }

    /**
     * @param value Flag for generating lags for the numeric features with 'auto' or null.
     */
    @JvmName("nnvbvysygyduddqk")
    public suspend fun featureLags(`value`: Either<String, FeatureLags>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureLags = mapped
    }

    /**
     * @param value Flag for generating lags for the numeric features with 'auto' or null.
     */
    @JvmName("oqxptxotuyurkyhs")
    public fun featureLags(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FeatureLags>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.featureLags = mapped
    }

    /**
     * @param value Flag for generating lags for the numeric features with 'auto' or null.
     */
    @JvmName("qgcxgvnyowbdanwj")
    public fun featureLags(`value`: FeatureLags) {
        val toBeMapped = Either.ofRight<String, FeatureLags>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.featureLags = mapped
    }

    /**
     * @param value The desired maximum forecast horizon in units of time-series frequency.
     */
    @JvmName("scxwpaotsxophkpl")
    public suspend
    fun forecastHorizon(`value`: Either<AutoForecastHorizonArgs, CustomForecastHorizonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forecastHorizon = mapped
    }

    /**
     * @param value The desired maximum forecast horizon in units of time-series frequency.
     */
    @JvmName("ntrbycvgyovyhboq")
    public fun forecastHorizon(`value`: AutoForecastHorizonArgs) {
        val toBeMapped = Either.ofLeft<AutoForecastHorizonArgs, CustomForecastHorizonArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forecastHorizon = mapped
    }

    /**
     * @param value The desired maximum forecast horizon in units of time-series frequency.
     */
    @JvmName("exkauesyfkkdnhkm")
    public fun forecastHorizon(`value`: CustomForecastHorizonArgs) {
        val toBeMapped = Either.ofRight<AutoForecastHorizonArgs, CustomForecastHorizonArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forecastHorizon = mapped
    }

    /**
     * @param value When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
     */
    @JvmName("bfvyagwrhjfghrjh")
    public suspend fun frequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Set time series seasonality as an integer multiple of the series frequency.
     * If seasonality is set to 'auto', it will be inferred.
     */
    @JvmName("obqecpppgeqnrwln")
    public suspend fun seasonality(`value`: Either<AutoSeasonalityArgs, CustomSeasonalityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seasonality = mapped
    }

    /**
     * @param value Set time series seasonality as an integer multiple of the series frequency.
     * If seasonality is set to 'auto', it will be inferred.
     */
    @JvmName("iokkunyiuowrmfrc")
    public fun seasonality(`value`: AutoSeasonalityArgs) {
        val toBeMapped = Either.ofLeft<AutoSeasonalityArgs, CustomSeasonalityArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seasonality = mapped
    }

    /**
     * @param value Set time series seasonality as an integer multiple of the series frequency.
     * If seasonality is set to 'auto', it will be inferred.
     */
    @JvmName("kaucerigqtxxrqks")
    public fun seasonality(`value`: CustomSeasonalityArgs) {
        val toBeMapped = Either.ofRight<AutoSeasonalityArgs, CustomSeasonalityArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seasonality = mapped
    }

    /**
     * @param value The parameter defining how if AutoML should handle short time series.
     */
    @JvmName("qaotqxiytplukwal")
    public suspend
    fun shortSeriesHandlingConfig(`value`: Either<String, ShortSeriesHandlingConfiguration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shortSeriesHandlingConfig = mapped
    }

    /**
     * @param value The parameter defining how if AutoML should handle short time series.
     */
    @JvmName("lwgijwermdrrulty")
    public fun shortSeriesHandlingConfig(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShortSeriesHandlingConfiguration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shortSeriesHandlingConfig = mapped
    }

    /**
     * @param value The parameter defining how if AutoML should handle short time series.
     */
    @JvmName("madrrwogsdjsppqs")
    public fun shortSeriesHandlingConfig(`value`: ShortSeriesHandlingConfiguration) {
        val toBeMapped = Either.ofRight<String, ShortSeriesHandlingConfiguration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shortSeriesHandlingConfig = mapped
    }

    /**
     * @param value The function to be used to aggregate the time series target column to conform to a user specified frequency.
     * If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     */
    @JvmName("fbqtpmgqutnhryac")
    public suspend fun targetAggregateFunction(`value`: Either<String, TargetAggregationFunction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAggregateFunction = mapped
    }

    /**
     * @param value The function to be used to aggregate the time series target column to conform to a user specified frequency.
     * If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     */
    @JvmName("wejsybqofqtajhby")
    public fun targetAggregateFunction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TargetAggregationFunction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAggregateFunction = mapped
    }

    /**
     * @param value The function to be used to aggregate the time series target column to conform to a user specified frequency.
     * If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     */
    @JvmName("nehbesmxrbrkwmor")
    public fun targetAggregateFunction(`value`: TargetAggregationFunction) {
        val toBeMapped = Either.ofRight<String, TargetAggregationFunction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAggregateFunction = mapped
    }

    /**
     * @param value The number of past periods to lag from the target column.
     */
    @JvmName("uytyfqprgdrexccm")
    public suspend fun targetLags(`value`: Either<AutoTargetLagsArgs, CustomTargetLagsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetLags = mapped
    }

    /**
     * @param value The number of past periods to lag from the target column.
     */
    @JvmName("dkofwdvwdmxopsgc")
    public fun targetLags(`value`: AutoTargetLagsArgs) {
        val toBeMapped = Either.ofLeft<AutoTargetLagsArgs, CustomTargetLagsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetLags = mapped
    }

    /**
     * @param value The number of past periods to lag from the target column.
     */
    @JvmName("mirwawueevdptoqn")
    public fun targetLags(`value`: CustomTargetLagsArgs) {
        val toBeMapped = Either.ofRight<AutoTargetLagsArgs, CustomTargetLagsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetLags = mapped
    }

    /**
     * @param value The number of past periods used to create a rolling window average of the target column.
     */
    @JvmName("nyyucoycsdbmljhw")
    public suspend
    fun targetRollingWindowSize(`value`: Either<AutoTargetRollingWindowSizeArgs, CustomTargetRollingWindowSizeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRollingWindowSize = mapped
    }

    /**
     * @param value The number of past periods used to create a rolling window average of the target column.
     */
    @JvmName("vfrprojmrlfekakb")
    public fun targetRollingWindowSize(`value`: AutoTargetRollingWindowSizeArgs) {
        val toBeMapped = Either.ofLeft<AutoTargetRollingWindowSizeArgs,
            CustomTargetRollingWindowSizeArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRollingWindowSize = mapped
    }

    /**
     * @param value The number of past periods used to create a rolling window average of the target column.
     */
    @JvmName("bgqhlpqhdohbjtyn")
    public fun targetRollingWindowSize(`value`: CustomTargetRollingWindowSizeArgs) {
        val toBeMapped = Either.ofRight<AutoTargetRollingWindowSizeArgs,
            CustomTargetRollingWindowSizeArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRollingWindowSize = mapped
    }

    /**
     * @param value The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
     */
    @JvmName("lgccmcblowpvimpy")
    public suspend fun timeColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeColumnName = mapped
    }

    /**
     * @param value The names of columns used to group a timeseries. It can be used to create multiple series.
     * If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
     */
    @JvmName("tvejwnkwrvrpljbe")
    public suspend fun timeSeriesIdColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesIdColumnNames = mapped
    }

    /**
     * @param values The names of columns used to group a timeseries. It can be used to create multiple series.
     * If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
     */
    @JvmName("vyvqoukpdpydjmkg")
    public suspend fun timeSeriesIdColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeSeriesIdColumnNames = mapped
    }

    /**
     * @param value Configure STL Decomposition of the time-series target column.
     */
    @JvmName("lksntftsujxdmack")
    public suspend fun useStl(`value`: Either<String, UseStl>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useStl = mapped
    }

    /**
     * @param value Configure STL Decomposition of the time-series target column.
     */
    @JvmName("iilixyvnoowkebpi")
    public fun useStl(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UseStl>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useStl = mapped
    }

    /**
     * @param value Configure STL Decomposition of the time-series target column.
     */
    @JvmName("orimltnyrhgrrpvn")
    public fun useStl(`value`: UseStl) {
        val toBeMapped = Either.ofRight<String, UseStl>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useStl = mapped
    }

    internal fun build(): ForecastingSettingsArgs = ForecastingSettingsArgs(
        countryOrRegionForHolidays = countryOrRegionForHolidays,
        cvStepSize = cvStepSize,
        featureLags = featureLags,
        forecastHorizon = forecastHorizon,
        frequency = frequency,
        seasonality = seasonality,
        shortSeriesHandlingConfig = shortSeriesHandlingConfig,
        targetAggregateFunction = targetAggregateFunction,
        targetLags = targetLags,
        targetRollingWindowSize = targetRollingWindowSize,
        timeColumnName = timeColumnName,
        timeSeriesIdColumnNames = timeSeriesIdColumnNames,
        useStl = useStl,
    )
}
