@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatasetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datasetName The Dataset name.
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetMachineLearningDatasetPlainArgs(
    public val datasetName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatasetPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatasetPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatasetPlainArgs.builder()
            .datasetName(datasetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineLearningDatasetPlainArgs].
 */
@PulumiTagMarker
public class GetMachineLearningDatasetPlainArgsBuilder internal constructor() {
    private var datasetName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The Dataset name.
     */
    @JvmName("klugoombddekiilk")
    public suspend fun datasetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.datasetName = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("lckdniewufyjfijg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("hpfjgkdevioaarky")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetMachineLearningDatasetPlainArgs = GetMachineLearningDatasetPlainArgs(
        datasetName = datasetName ?: throw PulumiNullFieldException("datasetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
