@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryEnvironmentContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName Container name. This is case-sensitive.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRegistryEnvironmentContainerPlainArgs(
    public val environmentName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryEnvironmentContainerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryEnvironmentContainerPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryEnvironmentContainerPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryEnvironmentContainerPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryEnvironmentContainerPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("ubckdssnanrcwqae")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("qkynnlulymswjteg")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kkbhliclanradbmg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRegistryEnvironmentContainerPlainArgs =
        GetRegistryEnvironmentContainerPlainArgs(
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            registryName = registryName ?: throw PulumiNullFieldException("registryName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
