@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property modelName Container name. This is case-sensitive.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier. This is case-sensitive.
 */
public data class GetRegistryModelVersionPlainArgs(
    public val modelName: String,
    public val registryName: String,
    public val resourceGroupName: String,
    public val version: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelVersionPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelVersionPlainArgs.builder()
            .modelName(modelName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryModelVersionPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryModelVersionPlainArgsBuilder internal constructor() {
    private var modelName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var version: String? = null

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("tkqattrwrwdrwchk")
    public suspend fun modelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("gkoqkecuyxmhoryu")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jjetsexqferypkxn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier. This is case-sensitive.
     */
    @JvmName("yutuuqswaeicjnks")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetRegistryModelVersionPlainArgs = GetRegistryModelVersionPlainArgs(
        modelName = modelName ?: throw PulumiNullFieldException("modelName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
