@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GridSamplingAlgorithmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines a Sampling Algorithm that exhaustively generates every value combination in the space
 * @property samplingAlgorithmType
 * Expected value is 'Grid'.
 */
public data class GridSamplingAlgorithmArgs(
    public val samplingAlgorithmType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GridSamplingAlgorithmArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GridSamplingAlgorithmArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GridSamplingAlgorithmArgs.builder()
            .samplingAlgorithmType(samplingAlgorithmType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GridSamplingAlgorithmArgs].
 */
@PulumiTagMarker
public class GridSamplingAlgorithmArgsBuilder internal constructor() {
    private var samplingAlgorithmType: Output<String>? = null

    /**
     * @param value
     * Expected value is 'Grid'.
     */
    @JvmName("syfnnqedxmdulpxm")
    public suspend fun samplingAlgorithmType(`value`: Output<String>) {
        this.samplingAlgorithmType = value
    }

    /**
     * @param value
     * Expected value is 'Grid'.
     */
    @JvmName("wdgavuvwjyvvxuig")
    public suspend fun samplingAlgorithmType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingAlgorithmType = mapped
    }

    internal fun build(): GridSamplingAlgorithmArgs = GridSamplingAlgorithmArgs(
        samplingAlgorithmType = samplingAlgorithmType ?: throw
            PulumiNullFieldException("samplingAlgorithmType"),
    )
}
