@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.IdAssetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an asset via its ARM resource ID.
 * @property assetId [Required] ARM resource ID of the asset.
 * @property referenceType Enum to determine which reference method to use for an asset.
 * Expected value is 'Id'.
 */
public data class IdAssetReferenceArgs(
    public val assetId: Output<String>,
    public val referenceType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.IdAssetReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.IdAssetReferenceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.IdAssetReferenceArgs.builder()
            .assetId(assetId.applyValue({ args0 -> args0 }))
            .referenceType(referenceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdAssetReferenceArgs].
 */
@PulumiTagMarker
public class IdAssetReferenceArgsBuilder internal constructor() {
    private var assetId: Output<String>? = null

    private var referenceType: Output<String>? = null

    /**
     * @param value [Required] ARM resource ID of the asset.
     */
    @JvmName("ywcewlpyyxouyxjk")
    public suspend fun assetId(`value`: Output<String>) {
        this.assetId = value
    }

    /**
     * @param value Enum to determine which reference method to use for an asset.
     * Expected value is 'Id'.
     */
    @JvmName("ejalnpwnwgmcylml")
    public suspend fun referenceType(`value`: Output<String>) {
        this.referenceType = value
    }

    /**
     * @param value [Required] ARM resource ID of the asset.
     */
    @JvmName("aequydvbhlpoexia")
    public suspend fun assetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assetId = mapped
    }

    /**
     * @param value Enum to determine which reference method to use for an asset.
     * Expected value is 'Id'.
     */
    @JvmName("lfneeuderbuuwnqx")
    public suspend fun referenceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceType = mapped
    }

    internal fun build(): IdAssetReferenceArgs = IdAssetReferenceArgs(
        assetId = assetId ?: throw PulumiNullFieldException("assetId"),
        referenceType = referenceType ?: throw PulumiNullFieldException("referenceType"),
    )
}
