@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ImageType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the Image Specifications
 * @property reference Image reference
 * @property type Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
 */
public data class ImageArgs(
    public val reference: Output<String>? = null,
    public val type: Output<Either<String, ImageType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ImageArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageArgs.builder()
            .reference(reference?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ImageArgs].
 */
@PulumiTagMarker
public class ImageArgsBuilder internal constructor() {
    private var reference: Output<String>? = null

    private var type: Output<Either<String, ImageType>>? = null

    /**
     * @param value Image reference
     */
    @JvmName("kqbqhmxyiiymfjns")
    public suspend fun reference(`value`: Output<String>) {
        this.reference = value
    }

    /**
     * @param value Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
     */
    @JvmName("usuaecepqjrpomqj")
    public suspend fun type(`value`: Output<Either<String, ImageType>>) {
        this.type = value
    }

    /**
     * @param value Image reference
     */
    @JvmName("gmopgjuvhdencjfe")
    public suspend fun reference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reference = mapped
    }

    /**
     * @param value Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
     */
    @JvmName("uaasixrhawqjtjxy")
    public suspend fun type(`value`: Either<String, ImageType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
     */
    @JvmName("mexmqwcrstiajvkd")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
     */
    @JvmName("grofnrpvavdptqpw")
    public fun type(`value`: ImageType) {
        val toBeMapped = Either.ofRight<String, ImageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageArgs = ImageArgs(
        reference = reference,
        type = type,
    )
}
