@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageSweepSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.SamplingAlgorithmType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model sweeping and hyperparameter sweeping related settings.
 * @property earlyTermination Type of early termination policy.
 * @property samplingAlgorithm [Required] Type of the hyperparameter sampling algorithms.
 */
public data class ImageSweepSettingsArgs(
    public val earlyTermination: Output<Any>? = null,
    public val samplingAlgorithm: Output<Either<String, SamplingAlgorithmType>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageSweepSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ImageSweepSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageSweepSettingsArgs.builder()
            .earlyTermination(earlyTermination?.applyValue({ args0 -> args0 }))
            .samplingAlgorithm(
                samplingAlgorithm.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ImageSweepSettingsArgs].
 */
@PulumiTagMarker
public class ImageSweepSettingsArgsBuilder internal constructor() {
    private var earlyTermination: Output<Any>? = null

    private var samplingAlgorithm: Output<Either<String, SamplingAlgorithmType>>? = null

    /**
     * @param value Type of early termination policy.
     */
    @JvmName("bbdebcqqmyiyiits")
    public suspend fun earlyTermination(`value`: Output<Any>) {
        this.earlyTermination = value
    }

    /**
     * @param value [Required] Type of the hyperparameter sampling algorithms.
     */
    @JvmName("utibyfjnreklgjga")
    public suspend fun samplingAlgorithm(`value`: Output<Either<String, SamplingAlgorithmType>>) {
        this.samplingAlgorithm = value
    }

    /**
     * @param value Type of early termination policy.
     */
    @JvmName("kituylhyvcvluvtj")
    public suspend fun earlyTermination(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyTermination = mapped
    }

    /**
     * @param value [Required] Type of the hyperparameter sampling algorithms.
     */
    @JvmName("tycptglebmjyetym")
    public suspend fun samplingAlgorithm(`value`: Either<String, SamplingAlgorithmType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingAlgorithm = mapped
    }

    /**
     * @param value [Required] Type of the hyperparameter sampling algorithms.
     */
    @JvmName("dgppoxkgphoqrnwk")
    public fun samplingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SamplingAlgorithmType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingAlgorithm = mapped
    }

    /**
     * @param value [Required] Type of the hyperparameter sampling algorithms.
     */
    @JvmName("pkvqorpsbstavowi")
    public fun samplingAlgorithm(`value`: SamplingAlgorithmType) {
        val toBeMapped = Either.ofRight<String, SamplingAlgorithmType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingAlgorithm = mapped
    }

    internal fun build(): ImageSweepSettingsArgs = ImageSweepSettingsArgs(
        earlyTermination = earlyTermination,
        samplingAlgorithm = samplingAlgorithm ?: throw PulumiNullFieldException("samplingAlgorithm"),
    )
}
