@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.IndexColumnArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.FeatureDataType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dto object representing index column
 * @property columnName Specifies the column name
 * @property dataType Specifies the data type
 */
public data class IndexColumnArgs(
    public val columnName: Output<String>? = null,
    public val dataType: Output<Either<String, FeatureDataType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.IndexColumnArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.IndexColumnArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.IndexColumnArgs.builder()
            .columnName(columnName?.applyValue({ args0 -> args0 }))
            .dataType(
                dataType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IndexColumnArgs].
 */
@PulumiTagMarker
public class IndexColumnArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var dataType: Output<Either<String, FeatureDataType>>? = null

    /**
     * @param value Specifies the column name
     */
    @JvmName("lpujouvfvkikgtgv")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value Specifies the data type
     */
    @JvmName("pmbbynrmlqjobrlj")
    public suspend fun dataType(`value`: Output<Either<String, FeatureDataType>>) {
        this.dataType = value
    }

    /**
     * @param value Specifies the column name
     */
    @JvmName("jylmdeaknxbcywty")
    public suspend fun columnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value Specifies the data type
     */
    @JvmName("mhafyhjyxjdapoay")
    public suspend fun dataType(`value`: Either<String, FeatureDataType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Specifies the data type
     */
    @JvmName("hsvggxibipsisikf")
    public fun dataType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FeatureDataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Specifies the data type
     */
    @JvmName("atklbiofsaifsufg")
    public fun dataType(`value`: FeatureDataType) {
        val toBeMapped = Either.ofRight<String, FeatureDataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    internal fun build(): IndexColumnArgs = IndexColumnArgs(
        columnName = columnName,
        dataType = dataType,
    )
}
