@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.InferenceContainerPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property livenessRoute The route to check the liveness of the inference server container.
 * @property readinessRoute The route to check the readiness of the inference server container.
 * @property scoringRoute The port to send the scoring requests to, within the inference server container.
 */
public data class InferenceContainerPropertiesArgs(
    public val livenessRoute: Output<RouteArgs>? = null,
    public val readinessRoute: Output<RouteArgs>? = null,
    public val scoringRoute: Output<RouteArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.InferenceContainerPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.InferenceContainerPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.InferenceContainerPropertiesArgs.builder()
            .livenessRoute(livenessRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readinessRoute(readinessRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scoringRoute(scoringRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InferenceContainerPropertiesArgs].
 */
@PulumiTagMarker
public class InferenceContainerPropertiesArgsBuilder internal constructor() {
    private var livenessRoute: Output<RouteArgs>? = null

    private var readinessRoute: Output<RouteArgs>? = null

    private var scoringRoute: Output<RouteArgs>? = null

    /**
     * @param value The route to check the liveness of the inference server container.
     */
    @JvmName("cuenjofvirnvghdi")
    public suspend fun livenessRoute(`value`: Output<RouteArgs>) {
        this.livenessRoute = value
    }

    /**
     * @param value The route to check the readiness of the inference server container.
     */
    @JvmName("dmhmkrvqktrqrner")
    public suspend fun readinessRoute(`value`: Output<RouteArgs>) {
        this.readinessRoute = value
    }

    /**
     * @param value The port to send the scoring requests to, within the inference server container.
     */
    @JvmName("kguibgxitcnyqgmn")
    public suspend fun scoringRoute(`value`: Output<RouteArgs>) {
        this.scoringRoute = value
    }

    /**
     * @param value The route to check the liveness of the inference server container.
     */
    @JvmName("sownqsxdureplwaw")
    public suspend fun livenessRoute(`value`: RouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessRoute = mapped
    }

    /**
     * @param argument The route to check the liveness of the inference server container.
     */
    @JvmName("vjiqtgmrqngvhcju")
    public suspend fun livenessRoute(argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = RouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.livenessRoute = mapped
    }

    /**
     * @param value The route to check the readiness of the inference server container.
     */
    @JvmName("crmhhthjkemraeji")
    public suspend fun readinessRoute(`value`: RouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessRoute = mapped
    }

    /**
     * @param argument The route to check the readiness of the inference server container.
     */
    @JvmName("hregeufwjjdqadvc")
    public suspend fun readinessRoute(argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = RouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readinessRoute = mapped
    }

    /**
     * @param value The port to send the scoring requests to, within the inference server container.
     */
    @JvmName("vrequwnirdonbbqd")
    public suspend fun scoringRoute(`value`: RouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scoringRoute = mapped
    }

    /**
     * @param argument The port to send the scoring requests to, within the inference server container.
     */
    @JvmName("nsshihnaekxfbnso")
    public suspend fun scoringRoute(argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = RouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scoringRoute = mapped
    }

    internal fun build(): InferenceContainerPropertiesArgs = InferenceContainerPropertiesArgs(
        livenessRoute = livenessRoute,
        readinessRoute = readinessRoute,
        scoringRoute = scoringRoute,
    )
}
