@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Instance type schema.
 * @property nodeSelector Node Selector
 * @property resources Resource requests/limits for this instance type
 */
public data class InstanceTypeSchemaArgs(
    public val nodeSelector: Output<Map<String, String>>? = null,
    public val resources: Output<InstanceTypeSchemaResourcesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaArgs.builder()
            .nodeSelector(
                nodeSelector?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InstanceTypeSchemaArgs].
 */
@PulumiTagMarker
public class InstanceTypeSchemaArgsBuilder internal constructor() {
    private var nodeSelector: Output<Map<String, String>>? = null

    private var resources: Output<InstanceTypeSchemaResourcesArgs>? = null

    /**
     * @param value Node Selector
     */
    @JvmName("fulqfaevweqwktth")
    public suspend fun nodeSelector(`value`: Output<Map<String, String>>) {
        this.nodeSelector = value
    }

    /**
     * @param value Resource requests/limits for this instance type
     */
    @JvmName("rarfbwoevwsqxrxv")
    public suspend fun resources(`value`: Output<InstanceTypeSchemaResourcesArgs>) {
        this.resources = value
    }

    /**
     * @param value Node Selector
     */
    @JvmName("lncqdagyqsgodvhx")
    public suspend fun nodeSelector(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeSelector = mapped
    }

    /**
     * @param values Node Selector
     */
    @JvmName("hqclxwnjascngvxk")
    public fun nodeSelector(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSelector = mapped
    }

    /**
     * @param value Resource requests/limits for this instance type
     */
    @JvmName("kjsacwysqefygecs")
    public suspend fun resources(`value`: InstanceTypeSchemaResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Resource requests/limits for this instance type
     */
    @JvmName("kopqohtavitkmkos")
    public suspend
    fun resources(argument: suspend InstanceTypeSchemaResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceTypeSchemaResourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    internal fun build(): InstanceTypeSchemaArgs = InstanceTypeSchemaArgs(
        nodeSelector = nodeSelector,
        resources = resources,
    )
}
