@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.JobServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Job endpoint definition
 * @property endpoint Url for endpoint.
 * @property jobServiceType Endpoint type.
 * @property nodes Nodes that user would like to start the service on.
 * If Nodes is not set or set to null, the service will only be started on leader node.
 * @property port Port for endpoint.
 * @property properties Additional properties to set on the endpoint.
 */
public data class JobServiceArgs(
    public val endpoint: Output<String>? = null,
    public val jobServiceType: Output<String>? = null,
    public val nodes: Output<AllNodesArgs>? = null,
    public val port: Output<Int>? = null,
    public val properties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.JobServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.JobServiceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.JobServiceArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .jobServiceType(jobServiceType?.applyValue({ args0 -> args0 }))
            .nodes(nodes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JobServiceArgs].
 */
@PulumiTagMarker
public class JobServiceArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var jobServiceType: Output<String>? = null

    private var nodes: Output<AllNodesArgs>? = null

    private var port: Output<Int>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value Url for endpoint.
     */
    @JvmName("dramtnscqwdspfmh")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Endpoint type.
     */
    @JvmName("udseswqehuyfcmwy")
    public suspend fun jobServiceType(`value`: Output<String>) {
        this.jobServiceType = value
    }

    /**
     * @param value Nodes that user would like to start the service on.
     * If Nodes is not set or set to null, the service will only be started on leader node.
     */
    @JvmName("vljpukpttwcyawpj")
    public suspend fun nodes(`value`: Output<AllNodesArgs>) {
        this.nodes = value
    }

    /**
     * @param value Port for endpoint.
     */
    @JvmName("kjcybtjpkayrhnup")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Additional properties to set on the endpoint.
     */
    @JvmName("qukjluyxgfrxoqxl")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Url for endpoint.
     */
    @JvmName("yowbvinmclgbdisi")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Endpoint type.
     */
    @JvmName("knwtllcwikewieln")
    public suspend fun jobServiceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobServiceType = mapped
    }

    /**
     * @param value Nodes that user would like to start the service on.
     * If Nodes is not set or set to null, the service will only be started on leader node.
     */
    @JvmName("vnbmslwavwtgswqb")
    public suspend fun nodes(`value`: AllNodesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodes = mapped
    }

    /**
     * @param argument Nodes that user would like to start the service on.
     * If Nodes is not set or set to null, the service will only be started on leader node.
     */
    @JvmName("ywealevddcuchaal")
    public suspend fun nodes(argument: suspend AllNodesArgsBuilder.() -> Unit) {
        val toBeMapped = AllNodesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodes = mapped
    }

    /**
     * @param value Port for endpoint.
     */
    @JvmName("sqphhsbpbisgxgtv")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Additional properties to set on the endpoint.
     */
    @JvmName("hrxvoxipbwsxoxoy")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Additional properties to set on the endpoint.
     */
    @JvmName("bskqairfjjsawkgy")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): JobServiceArgs = JobServiceArgs(
        endpoint = endpoint,
        jobServiceType = jobServiceType,
        nodes = nodes,
        port = port,
        properties = properties,
    )
}
