@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.KubernetesOnlineDeploymentArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.EgressPublicNetworkAccessType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties specific to a KubernetesOnlineDeployment.
 * @property appInsightsEnabled If true, enables Application Insights logging.
 * @property codeConfiguration Code configuration for the endpoint deployment.
 * @property containerResourceRequirements The resource requirements for the container (cpu and memory).
 * @property description Description of the endpoint deployment.
 * @property egressPublicNetworkAccess If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
 * @property endpointComputeType Enum to determine endpoint compute type.
 * Expected value is 'Kubernetes'.
 * @property environmentId ARM resource ID or AssetId of the environment specification for the endpoint deployment.
 * @property environmentVariables Environment variables configuration for the deployment.
 * @property instanceType Compute instance type.
 * @property livenessProbe Liveness probe monitors the health of the container regularly.
 * @property model The URI path to the model.
 * @property modelMountPath The path to mount the model in custom container.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property readinessProbe Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
 * @property requestSettings Request settings for the deployment.
 * @property scaleSettings Scale settings for the deployment.
 * If it is null or not provided,
 * it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
 * and to DefaultScaleSettings for ManagedOnlineDeployment.
 */
public data class KubernetesOnlineDeploymentArgs(
    public val appInsightsEnabled: Output<Boolean>? = null,
    public val codeConfiguration: Output<CodeConfigurationArgs>? = null,
    public val containerResourceRequirements: Output<ContainerResourceRequirementsArgs>? = null,
    public val description: Output<String>? = null,
    public val egressPublicNetworkAccess: Output<Either<String, EgressPublicNetworkAccessType>>? =
        null,
    public val endpointComputeType: Output<String>,
    public val environmentId: Output<String>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val instanceType: Output<String>? = null,
    public val livenessProbe: Output<ProbeSettingsArgs>? = null,
    public val model: Output<String>? = null,
    public val modelMountPath: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val readinessProbe: Output<ProbeSettingsArgs>? = null,
    public val requestSettings: Output<OnlineRequestSettingsArgs>? = null,
    public val scaleSettings:
    Output<Either<DefaultScaleSettingsArgs, TargetUtilizationScaleSettingsArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.KubernetesOnlineDeploymentArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.KubernetesOnlineDeploymentArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.KubernetesOnlineDeploymentArgs.builder()
            .appInsightsEnabled(appInsightsEnabled?.applyValue({ args0 -> args0 }))
            .codeConfiguration(codeConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerResourceRequirements(
                containerResourceRequirements?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .egressPublicNetworkAccess(
                egressPublicNetworkAccess?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .endpointComputeType(endpointComputeType.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .livenessProbe(livenessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .model(model?.applyValue({ args0 -> args0 }))
            .modelMountPath(modelMountPath?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .readinessProbe(readinessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requestSettings(requestSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scaleSettings(
                scaleSettings?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [KubernetesOnlineDeploymentArgs].
 */
@PulumiTagMarker
public class KubernetesOnlineDeploymentArgsBuilder internal constructor() {
    private var appInsightsEnabled: Output<Boolean>? = null

    private var codeConfiguration: Output<CodeConfigurationArgs>? = null

    private var containerResourceRequirements: Output<ContainerResourceRequirementsArgs>? = null

    private var description: Output<String>? = null

    private var egressPublicNetworkAccess: Output<Either<String, EgressPublicNetworkAccessType>>? =
        null

    private var endpointComputeType: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var instanceType: Output<String>? = null

    private var livenessProbe: Output<ProbeSettingsArgs>? = null

    private var model: Output<String>? = null

    private var modelMountPath: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var readinessProbe: Output<ProbeSettingsArgs>? = null

    private var requestSettings: Output<OnlineRequestSettingsArgs>? = null

    private var scaleSettings:
        Output<Either<DefaultScaleSettingsArgs, TargetUtilizationScaleSettingsArgs>>? = null

    /**
     * @param value If true, enables Application Insights logging.
     */
    @JvmName("dwuooeugcfakcdqx")
    public suspend fun appInsightsEnabled(`value`: Output<Boolean>) {
        this.appInsightsEnabled = value
    }

    /**
     * @param value Code configuration for the endpoint deployment.
     */
    @JvmName("loptmuonfnvsoupe")
    public suspend fun codeConfiguration(`value`: Output<CodeConfigurationArgs>) {
        this.codeConfiguration = value
    }

    /**
     * @param value The resource requirements for the container (cpu and memory).
     */
    @JvmName("ilyijljhnhkquhyx")
    public suspend
    fun containerResourceRequirements(`value`: Output<ContainerResourceRequirementsArgs>) {
        this.containerResourceRequirements = value
    }

    /**
     * @param value Description of the endpoint deployment.
     */
    @JvmName("yvdchmibgfduodek")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
     */
    @JvmName("lpilowultrpfdobc")
    public suspend
    fun egressPublicNetworkAccess(`value`: Output<Either<String, EgressPublicNetworkAccessType>>) {
        this.egressPublicNetworkAccess = value
    }

    /**
     * @param value Enum to determine endpoint compute type.
     * Expected value is 'Kubernetes'.
     */
    @JvmName("njomodowceotxuft")
    public suspend fun endpointComputeType(`value`: Output<String>) {
        this.endpointComputeType = value
    }

    /**
     * @param value ARM resource ID or AssetId of the environment specification for the endpoint deployment.
     */
    @JvmName("wqbuvgpkcnehqmuk")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Environment variables configuration for the deployment.
     */
    @JvmName("ajamtyilvolekjpy")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Compute instance type.
     */
    @JvmName("vjjrgavxehxpamxi")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Liveness probe monitors the health of the container regularly.
     */
    @JvmName("plhxqvfonaflljsc")
    public suspend fun livenessProbe(`value`: Output<ProbeSettingsArgs>) {
        this.livenessProbe = value
    }

    /**
     * @param value The URI path to the model.
     */
    @JvmName("xiflsekaumswsjhe")
    public suspend fun model(`value`: Output<String>) {
        this.model = value
    }

    /**
     * @param value The path to mount the model in custom container.
     */
    @JvmName("gkiwyobclgexmhuq")
    public suspend fun modelMountPath(`value`: Output<String>) {
        this.modelMountPath = value
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("abdavyaxxjopeilu")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
     */
    @JvmName("dmipqxagaddedslx")
    public suspend fun readinessProbe(`value`: Output<ProbeSettingsArgs>) {
        this.readinessProbe = value
    }

    /**
     * @param value Request settings for the deployment.
     */
    @JvmName("kfscksbmoyklvgen")
    public suspend fun requestSettings(`value`: Output<OnlineRequestSettingsArgs>) {
        this.requestSettings = value
    }

    /**
     * @param value Scale settings for the deployment.
     * If it is null or not provided,
     * it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     * and to DefaultScaleSettings for ManagedOnlineDeployment.
     */
    @JvmName("povspgsmmujltylv")
    public suspend
    fun scaleSettings(`value`: Output<Either<DefaultScaleSettingsArgs, TargetUtilizationScaleSettingsArgs>>) {
        this.scaleSettings = value
    }

    /**
     * @param value If true, enables Application Insights logging.
     */
    @JvmName("kaalggicdxbwjhfa")
    public suspend fun appInsightsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appInsightsEnabled = mapped
    }

    /**
     * @param value Code configuration for the endpoint deployment.
     */
    @JvmName("pnmuggnuawgehhlc")
    public suspend fun codeConfiguration(`value`: CodeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeConfiguration = mapped
    }

    /**
     * @param argument Code configuration for the endpoint deployment.
     */
    @JvmName("becfpspuqlgiugci")
    public suspend fun codeConfiguration(argument: suspend CodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CodeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.codeConfiguration = mapped
    }

    /**
     * @param value The resource requirements for the container (cpu and memory).
     */
    @JvmName("iuufgtvurhuaxevt")
    public suspend fun containerResourceRequirements(`value`: ContainerResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerResourceRequirements = mapped
    }

    /**
     * @param argument The resource requirements for the container (cpu and memory).
     */
    @JvmName("icnjvdhoasllqlgn")
    public suspend
    fun containerResourceRequirements(argument: suspend ContainerResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerResourceRequirements = mapped
    }

    /**
     * @param value Description of the endpoint deployment.
     */
    @JvmName("qyiohhaertksopvy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
     */
    @JvmName("dhbwcymoparbayvf")
    public suspend
    fun egressPublicNetworkAccess(`value`: Either<String, EgressPublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressPublicNetworkAccess = mapped
    }

    /**
     * @param value If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
     */
    @JvmName("blaqdkglyyjwqpmf")
    public fun egressPublicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EgressPublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressPublicNetworkAccess = mapped
    }

    /**
     * @param value If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
     */
    @JvmName("gsyasmepsrjhhydv")
    public fun egressPublicNetworkAccess(`value`: EgressPublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, EgressPublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressPublicNetworkAccess = mapped
    }

    /**
     * @param value Enum to determine endpoint compute type.
     * Expected value is 'Kubernetes'.
     */
    @JvmName("bnnnhyawinmoxobi")
    public suspend fun endpointComputeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointComputeType = mapped
    }

    /**
     * @param value ARM resource ID or AssetId of the environment specification for the endpoint deployment.
     */
    @JvmName("gookaetnebyqttdk")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Environment variables configuration for the deployment.
     */
    @JvmName("araidrwgmffpgqgj")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables configuration for the deployment.
     */
    @JvmName("gwpunxuociuykkuv")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Compute instance type.
     */
    @JvmName("tftyjyokdgjlktue")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Liveness probe monitors the health of the container regularly.
     */
    @JvmName("qtwinrctrgkxqkgl")
    public suspend fun livenessProbe(`value`: ProbeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbe = mapped
    }

    /**
     * @param argument Liveness probe monitors the health of the container regularly.
     */
    @JvmName("qjwneoxhqbuvactv")
    public suspend fun livenessProbe(argument: suspend ProbeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.livenessProbe = mapped
    }

    /**
     * @param value The URI path to the model.
     */
    @JvmName("gpqcliddjuxeaowl")
    public suspend fun model(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value The path to mount the model in custom container.
     */
    @JvmName("mbsqjvpimliwtajc")
    public suspend fun modelMountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelMountPath = mapped
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("ygdrxngletljwosh")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("qoqeyuqqfbhpidqm")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
     */
    @JvmName("qlomcgdkdctxegmh")
    public suspend fun readinessProbe(`value`: ProbeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbe = mapped
    }

    /**
     * @param argument Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
     */
    @JvmName("ctjwnayintddwjcj")
    public suspend fun readinessProbe(argument: suspend ProbeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readinessProbe = mapped
    }

    /**
     * @param value Request settings for the deployment.
     */
    @JvmName("qowffgwsivstopqb")
    public suspend fun requestSettings(`value`: OnlineRequestSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestSettings = mapped
    }

    /**
     * @param argument Request settings for the deployment.
     */
    @JvmName("jjpksjblxmnegkmd")
    public suspend
    fun requestSettings(argument: suspend OnlineRequestSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = OnlineRequestSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requestSettings = mapped
    }

    /**
     * @param value Scale settings for the deployment.
     * If it is null or not provided,
     * it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     * and to DefaultScaleSettings for ManagedOnlineDeployment.
     */
    @JvmName("amkmojgdaclgdbkn")
    public suspend
    fun scaleSettings(`value`: Either<DefaultScaleSettingsArgs, TargetUtilizationScaleSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleSettings = mapped
    }

    /**
     * @param value Scale settings for the deployment.
     * If it is null or not provided,
     * it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     * and to DefaultScaleSettings for ManagedOnlineDeployment.
     */
    @JvmName("kepqiltrnctvgbto")
    public fun scaleSettings(`value`: DefaultScaleSettingsArgs) {
        val toBeMapped = Either.ofLeft<DefaultScaleSettingsArgs,
            TargetUtilizationScaleSettingsArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleSettings = mapped
    }

    /**
     * @param value Scale settings for the deployment.
     * If it is null or not provided,
     * it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     * and to DefaultScaleSettings for ManagedOnlineDeployment.
     */
    @JvmName("cvpteexoclxpxpso")
    public fun scaleSettings(`value`: TargetUtilizationScaleSettingsArgs) {
        val toBeMapped = Either.ofRight<DefaultScaleSettingsArgs,
            TargetUtilizationScaleSettingsArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleSettings = mapped
    }

    internal fun build(): KubernetesOnlineDeploymentArgs = KubernetesOnlineDeploymentArgs(
        appInsightsEnabled = appInsightsEnabled,
        codeConfiguration = codeConfiguration,
        containerResourceRequirements = containerResourceRequirements,
        description = description,
        egressPublicNetworkAccess = egressPublicNetworkAccess,
        endpointComputeType = endpointComputeType ?: throw PulumiNullFieldException("endpointComputeType"),
        environmentId = environmentId,
        environmentVariables = environmentVariables,
        instanceType = instanceType,
        livenessProbe = livenessProbe,
        model = model,
        modelMountPath = modelMountPath,
        properties = properties,
        readinessProbe = readinessProbe,
        requestSettings = requestSettings,
        scaleSettings = scaleSettings,
    )
}
