@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LabelCategoryArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.MultiSelect
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Label category definition
 * @property classes Dictionary of label classes in this category.
 * @property displayName Display name of the label category.
 * @property multiSelect Indicates whether it is allowed to select multiple classes in this category.
 */
public data class LabelCategoryArgs(
    public val classes: Output<Map<String, LabelClassArgs>>? = null,
    public val displayName: Output<String>? = null,
    public val multiSelect: Output<Either<String, MultiSelect>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LabelCategoryArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.LabelCategoryArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LabelCategoryArgs.builder()
            .classes(
                classes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                args0.toJava()
                            }),
                        )
                    }).toMap()
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .multiSelect(
                multiSelect?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LabelCategoryArgs].
 */
@PulumiTagMarker
public class LabelCategoryArgsBuilder internal constructor() {
    private var classes: Output<Map<String, LabelClassArgs>>? = null

    private var displayName: Output<String>? = null

    private var multiSelect: Output<Either<String, MultiSelect>>? = null

    /**
     * @param value Dictionary of label classes in this category.
     */
    @JvmName("pbqthpexoyyippmo")
    public suspend fun classes(`value`: Output<Map<String, LabelClassArgs>>) {
        this.classes = value
    }

    /**
     * @param value Display name of the label category.
     */
    @JvmName("ykigmwbqwaothecl")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Indicates whether it is allowed to select multiple classes in this category.
     */
    @JvmName("fbpdtlngasnrftvy")
    public suspend fun multiSelect(`value`: Output<Either<String, MultiSelect>>) {
        this.multiSelect = value
    }

    /**
     * @param value Dictionary of label classes in this category.
     */
    @JvmName("oslodfcytrldwgsn")
    public suspend fun classes(`value`: Map<String, LabelClassArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classes = mapped
    }

    /**
     * @param argument Dictionary of label classes in this category.
     */
    @JvmName("bnsuhglpwrgaambv")
    public suspend fun classes(
        vararg
        argument: Pair<String, suspend LabelClassArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                LabelClassArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.classes = mapped
    }

    /**
     * @param values Dictionary of label classes in this category.
     */
    @JvmName("dlfvyjyorpvrvypo")
    public fun classes(vararg values: Pair<String, LabelClassArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classes = mapped
    }

    /**
     * @param value Display name of the label category.
     */
    @JvmName("sxqoukwiwuoqcdia")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Indicates whether it is allowed to select multiple classes in this category.
     */
    @JvmName("avalcltvdvitgtwo")
    public suspend fun multiSelect(`value`: Either<String, MultiSelect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiSelect = mapped
    }

    /**
     * @param value Indicates whether it is allowed to select multiple classes in this category.
     */
    @JvmName("qynaiecxjspafluo")
    public fun multiSelect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MultiSelect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiSelect = mapped
    }

    /**
     * @param value Indicates whether it is allowed to select multiple classes in this category.
     */
    @JvmName("cyybdvexlxpkmrat")
    public fun multiSelect(`value`: MultiSelect) {
        val toBeMapped = Either.ofRight<String, MultiSelect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiSelect = mapped
    }

    internal fun build(): LabelCategoryArgs = LabelCategoryArgs(
        classes = classes,
        displayName = displayName,
        multiSelect = multiSelect,
    )
}
