@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LinkedServicePropsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LinkedServiceLinkType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * LinkedService specific properties.
 * @property createdTime The creation time of the linked service.
 * @property linkType Type of the link target.
 * @property linkedServiceResourceId ResourceId of the link target of the linked service.
 * @property modifiedTime The last modified time of the linked service.
 */
public data class LinkedServicePropsArgs(
    public val createdTime: Output<String>? = null,
    public val linkType: Output<LinkedServiceLinkType>? = null,
    public val linkedServiceResourceId: Output<String>,
    public val modifiedTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LinkedServicePropsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.LinkedServicePropsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LinkedServicePropsArgs.builder()
            .createdTime(createdTime?.applyValue({ args0 -> args0 }))
            .linkType(linkType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceResourceId(linkedServiceResourceId.applyValue({ args0 -> args0 }))
            .modifiedTime(modifiedTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedServicePropsArgs].
 */
@PulumiTagMarker
public class LinkedServicePropsArgsBuilder internal constructor() {
    private var createdTime: Output<String>? = null

    private var linkType: Output<LinkedServiceLinkType>? = null

    private var linkedServiceResourceId: Output<String>? = null

    private var modifiedTime: Output<String>? = null

    /**
     * @param value The creation time of the linked service.
     */
    @JvmName("biccxcllqcliushf")
    public suspend fun createdTime(`value`: Output<String>) {
        this.createdTime = value
    }

    /**
     * @param value Type of the link target.
     */
    @JvmName("nfevbqgilticepwm")
    public suspend fun linkType(`value`: Output<LinkedServiceLinkType>) {
        this.linkType = value
    }

    /**
     * @param value ResourceId of the link target of the linked service.
     */
    @JvmName("qsmunftkmlytfqpf")
    public suspend fun linkedServiceResourceId(`value`: Output<String>) {
        this.linkedServiceResourceId = value
    }

    /**
     * @param value The last modified time of the linked service.
     */
    @JvmName("wsuxruuugsovqpeg")
    public suspend fun modifiedTime(`value`: Output<String>) {
        this.modifiedTime = value
    }

    /**
     * @param value The creation time of the linked service.
     */
    @JvmName("qljctcksfdhmhmqu")
    public suspend fun createdTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdTime = mapped
    }

    /**
     * @param value Type of the link target.
     */
    @JvmName("swwcufffqjrjkgym")
    public suspend fun linkType(`value`: LinkedServiceLinkType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkType = mapped
    }

    /**
     * @param value ResourceId of the link target of the linked service.
     */
    @JvmName("dlhrfsranfipuvwi")
    public suspend fun linkedServiceResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceResourceId = mapped
    }

    /**
     * @param value The last modified time of the linked service.
     */
    @JvmName("jdipxvbgegftaepx")
    public suspend fun modifiedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedTime = mapped
    }

    internal fun build(): LinkedServicePropsArgs = LinkedServicePropsArgs(
        createdTime = createdTime,
        linkType = linkType,
        linkedServiceResourceId = linkedServiceResourceId ?: throw
            PulumiNullFieldException("linkedServiceResourceId"),
        modifiedTime = modifiedTime,
    )
}
