@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionFeaturesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Featureset name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skip Continuation token for pagination.
 * @property tags Comma-separated list of tag names (and optionally values). Example: tag1,tag2=value2
 * @property version Featureset Version identifier. This is case-sensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ListFeaturesetVersionFeaturesPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val skip: String? = null,
    public val tags: String? = null,
    public val version: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionFeaturesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionFeaturesPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionFeaturesPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFeaturesetVersionFeaturesPlainArgs].
 */
@PulumiTagMarker
public class ListFeaturesetVersionFeaturesPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var skip: String? = null

    private var tags: String? = null

    private var version: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Featureset name. This is case-sensitive.
     */
    @JvmName("lqhbqwgpdqkevman")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("grqcbpxcovmyutfd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Continuation token for pagination.
     */
    @JvmName("hiebfpcxdklymfwg")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value Comma-separated list of tag names (and optionally values). Example: tag1,tag2=value2
     */
    @JvmName("fynkgftaptojpmgr")
    public suspend fun tags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Featureset Version identifier. This is case-sensitive.
     */
    @JvmName("xtfateswrbnjldlj")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("hmuebkptjojbdwrx")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): ListFeaturesetVersionFeaturesPlainArgs =
        ListFeaturesetVersionFeaturesPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skip = skip,
            tags = tags,
            version = version ?: throw PulumiNullFieldException("version"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
