@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ListWorkspaceNotebookAccessTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ListWorkspaceNotebookAccessTokenPlainArgs(
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ListWorkspaceNotebookAccessTokenPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ListWorkspaceNotebookAccessTokenPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ListWorkspaceNotebookAccessTokenPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkspaceNotebookAccessTokenPlainArgs].
 */
@PulumiTagMarker
public class ListWorkspaceNotebookAccessTokenPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xvirxvluvxixpewc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("yutqlyqjfbayyquy")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): ListWorkspaceNotebookAccessTokenPlainArgs =
        ListWorkspaceNotebookAccessTokenPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
