@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ManagedOnlineEndpointDeploymentResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failureReason The failure reason if the creation failed.
 * @property type Kind of the deployment.
 * Expected value is 'managedOnlineEndpoint'.
 */
public data class ManagedOnlineEndpointDeploymentResourcePropertiesArgs(
    public val failureReason: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ManagedOnlineEndpointDeploymentResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ManagedOnlineEndpointDeploymentResourcePropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ManagedOnlineEndpointDeploymentResourcePropertiesArgs.builder()
            .failureReason(failureReason?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedOnlineEndpointDeploymentResourcePropertiesArgs].
 */
@PulumiTagMarker
public class ManagedOnlineEndpointDeploymentResourcePropertiesArgsBuilder internal constructor() {
    private var failureReason: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The failure reason if the creation failed.
     */
    @JvmName("pataqwhcdkttxdgn")
    public suspend fun failureReason(`value`: Output<String>) {
        this.failureReason = value
    }

    /**
     * @param value Kind of the deployment.
     * Expected value is 'managedOnlineEndpoint'.
     */
    @JvmName("xttsbpatipeqweet")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The failure reason if the creation failed.
     */
    @JvmName("slevcsrdmdrllgeu")
    public suspend fun failureReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureReason = mapped
    }

    /**
     * @param value Kind of the deployment.
     * Expected value is 'managedOnlineEndpoint'.
     */
    @JvmName("vnilwchagrpdenml")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedOnlineEndpointDeploymentResourcePropertiesArgs =
        ManagedOnlineEndpointDeploymentResourcePropertiesArgs(
            failureReason = failureReason,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
