@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MarketplaceSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property modelId [Required] Target Marketplace Model ID to create a Marketplace Subscription for.
 */
public data class MarketplaceSubscriptionArgs(
    public val modelId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MarketplaceSubscriptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.MarketplaceSubscriptionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MarketplaceSubscriptionArgs.builder()
            .modelId(modelId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MarketplaceSubscriptionArgs].
 */
@PulumiTagMarker
public class MarketplaceSubscriptionArgsBuilder internal constructor() {
    private var modelId: Output<String>? = null

    /**
     * @param value [Required] Target Marketplace Model ID to create a Marketplace Subscription for.
     */
    @JvmName("vtkwpfjhavejxkyd")
    public suspend fun modelId(`value`: Output<String>) {
        this.modelId = value
    }

    /**
     * @param value [Required] Target Marketplace Model ID to create a Marketplace Subscription for.
     */
    @JvmName("pgxsqieniywkscui")
    public suspend fun modelId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modelId = mapped
    }

    internal fun build(): MarketplaceSubscriptionArgs = MarketplaceSubscriptionArgs(
        modelId = modelId ?: throw PulumiNullFieldException("modelId"),
    )
}
