@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.NoneDatastoreCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Empty/none datastore credentials.
 * @property credentialsType Enum to determine the datastore credentials type.
 * Expected value is 'None'.
 */
public data class NoneDatastoreCredentialsArgs(
    public val credentialsType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.NoneDatastoreCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.NoneDatastoreCredentialsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.NoneDatastoreCredentialsArgs.builder()
            .credentialsType(credentialsType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NoneDatastoreCredentialsArgs].
 */
@PulumiTagMarker
public class NoneDatastoreCredentialsArgsBuilder internal constructor() {
    private var credentialsType: Output<String>? = null

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'None'.
     */
    @JvmName("uoervbbtedribotf")
    public suspend fun credentialsType(`value`: Output<String>) {
        this.credentialsType = value
    }

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'None'.
     */
    @JvmName("mbpwhwsthtcjjbdt")
    public suspend fun credentialsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsType = mapped
    }

    internal fun build(): NoneDatastoreCredentialsArgs = NoneDatastoreCredentialsArgs(
        credentialsType = credentialsType ?: throw PulumiNullFieldException("credentialsType"),
    )
}
