@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.OnlineEndpointArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.EndpointAuthMode
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.PublicNetworkAccessType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Online endpoint configuration
 * @property authMode [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
 * @property compute ARM resource ID of the compute if it exists.
 * optional
 * @property description Description of the inference endpoint.
 * @property keys EndpointAuthKeys to set initially on an Endpoint.
 * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
 * @property mirrorTraffic Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property publicNetworkAccess Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
 * @property traffic Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
 */
public data class OnlineEndpointArgs(
    public val authMode: Output<Either<String, EndpointAuthMode>>,
    public val compute: Output<String>? = null,
    public val description: Output<String>? = null,
    public val keys: Output<EndpointAuthKeysArgs>? = null,
    public val mirrorTraffic: Output<Map<String, Int>>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null,
    public val traffic: Output<Map<String, Int>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.OnlineEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.OnlineEndpointArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.OnlineEndpointArgs.builder()
            .authMode(
                authMode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .compute(compute?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .keys(keys?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mirrorTraffic(
                mirrorTraffic?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .traffic(
                traffic?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OnlineEndpointArgs].
 */
@PulumiTagMarker
public class OnlineEndpointArgsBuilder internal constructor() {
    private var authMode: Output<Either<String, EndpointAuthMode>>? = null

    private var compute: Output<String>? = null

    private var description: Output<String>? = null

    private var keys: Output<EndpointAuthKeysArgs>? = null

    private var mirrorTraffic: Output<Map<String, Int>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null

    private var traffic: Output<Map<String, Int>>? = null

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("ubgybvsbsgfndmci")
    public suspend fun authMode(`value`: Output<Either<String, EndpointAuthMode>>) {
        this.authMode = value
    }

    /**
     * @param value ARM resource ID of the compute if it exists.
     * optional
     */
    @JvmName("einqstnvtoouobwk")
    public suspend fun compute(`value`: Output<String>) {
        this.compute = value
    }

    /**
     * @param value Description of the inference endpoint.
     */
    @JvmName("ypfpyxjawbcnbmjv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value EndpointAuthKeys to set initially on an Endpoint.
     * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
     */
    @JvmName("flgibhabftykygeg")
    public suspend fun keys(`value`: Output<EndpointAuthKeysArgs>) {
        this.keys = value
    }

    /**
     * @param value Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50.
     */
    @JvmName("dkmcnuqehswebced")
    public suspend fun mirrorTraffic(`value`: Output<Map<String, Int>>) {
        this.mirrorTraffic = value
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("xehsyviwttyhtarf")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
     */
    @JvmName("qlsqcpnbyusgfikx")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
     */
    @JvmName("ynbepdqdfaslfpuq")
    public suspend fun traffic(`value`: Output<Map<String, Int>>) {
        this.traffic = value
    }

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("mwgctyrjubeyamjl")
    public suspend fun authMode(`value`: Either<String, EndpointAuthMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("semdxeedwdpeonyv")
    public fun authMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     */
    @JvmName("hkndpvvbmwhwjkal")
    public fun authMode(`value`: EndpointAuthMode) {
        val toBeMapped = Either.ofRight<String, EndpointAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value ARM resource ID of the compute if it exists.
     * optional
     */
    @JvmName("ohmpmtdkldqkywlp")
    public suspend fun compute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compute = mapped
    }

    /**
     * @param value Description of the inference endpoint.
     */
    @JvmName("vshbtuwadewuflra")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value EndpointAuthKeys to set initially on an Endpoint.
     * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
     */
    @JvmName("ynpjjqafsqtjrmfa")
    public suspend fun keys(`value`: EndpointAuthKeysArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param argument EndpointAuthKeys to set initially on an Endpoint.
     * This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
     */
    @JvmName("ipryibqdieirkbti")
    public suspend fun keys(argument: suspend EndpointAuthKeysArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointAuthKeysArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keys = mapped
    }

    /**
     * @param value Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50.
     */
    @JvmName("qujnkxiklcmobmli")
    public suspend fun mirrorTraffic(`value`: Map<String, Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorTraffic = mapped
    }

    /**
     * @param values Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50.
     */
    @JvmName("xgyafswineokouxn")
    public fun mirrorTraffic(vararg values: Pair<String, Int>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mirrorTraffic = mapped
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("rndampwijbphtoyu")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("vssxgdlodlukjewe")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
     */
    @JvmName("afnjjovdaulnvevu")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
     */
    @JvmName("ttphbravjftybcbh")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
     */
    @JvmName("jabhcmxprcktkguc")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
     */
    @JvmName("coxpeppwdgvgtysa")
    public suspend fun traffic(`value`: Map<String, Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traffic = mapped
    }

    /**
     * @param values Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
     */
    @JvmName("jybyvtbjlfbagxkw")
    public fun traffic(vararg values: Pair<String, Int>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.traffic = mapped
    }

    internal fun build(): OnlineEndpointArgs = OnlineEndpointArgs(
        authMode = authMode ?: throw PulumiNullFieldException("authMode"),
        compute = compute,
        description = description,
        keys = keys,
        mirrorTraffic = mirrorTraffic,
        properties = properties,
        publicNetworkAccess = publicNetworkAccess,
        traffic = traffic,
    )
}
