@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PoolEnvironmentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Environment configuration options.
 * @property environmentId ARM resource ID of the environment specification for the inference pool.
 * @property environmentVariables Environment variables configuration for the inference pool.
 * @property livenessProbe Liveness probe monitors the health of the container regularly.
 * @property readinessProbe Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
 * @property startupProbe This verifies whether the application within a container is started. Startup probes run before any other probe, and, unless it finishes successfully, disables other probes.
 */
public data class PoolEnvironmentConfigurationArgs(
    public val environmentId: Output<String>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val livenessProbe: Output<ProbeSettingsArgs>? = null,
    public val readinessProbe: Output<ProbeSettingsArgs>? = null,
    public val startupProbe: Output<ProbeSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PoolEnvironmentConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.PoolEnvironmentConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PoolEnvironmentConfigurationArgs.builder()
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .livenessProbe(livenessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readinessProbe(readinessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startupProbe(startupProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PoolEnvironmentConfigurationArgs].
 */
@PulumiTagMarker
public class PoolEnvironmentConfigurationArgsBuilder internal constructor() {
    private var environmentId: Output<String>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var livenessProbe: Output<ProbeSettingsArgs>? = null

    private var readinessProbe: Output<ProbeSettingsArgs>? = null

    private var startupProbe: Output<ProbeSettingsArgs>? = null

    /**
     * @param value ARM resource ID of the environment specification for the inference pool.
     */
    @JvmName("lqdegqfihsmfxriq")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Environment variables configuration for the inference pool.
     */
    @JvmName("cbukvokchwbhgsmr")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Liveness probe monitors the health of the container regularly.
     */
    @JvmName("srsrihgnjwqwfojb")
    public suspend fun livenessProbe(`value`: Output<ProbeSettingsArgs>) {
        this.livenessProbe = value
    }

    /**
     * @param value Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
     */
    @JvmName("ovybxuldcsbrssfy")
    public suspend fun readinessProbe(`value`: Output<ProbeSettingsArgs>) {
        this.readinessProbe = value
    }

    /**
     * @param value This verifies whether the application within a container is started. Startup probes run before any other probe, and, unless it finishes successfully, disables other probes.
     */
    @JvmName("nglyndmfhodvdpqi")
    public suspend fun startupProbe(`value`: Output<ProbeSettingsArgs>) {
        this.startupProbe = value
    }

    /**
     * @param value ARM resource ID of the environment specification for the inference pool.
     */
    @JvmName("cueyqaxqfsmpsvgb")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Environment variables configuration for the inference pool.
     */
    @JvmName("igqiliputjepbwym")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables configuration for the inference pool.
     */
    @JvmName("sufoegtqgkqeobrv")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Liveness probe monitors the health of the container regularly.
     */
    @JvmName("psjlroclooifcwsx")
    public suspend fun livenessProbe(`value`: ProbeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbe = mapped
    }

    /**
     * @param argument Liveness probe monitors the health of the container regularly.
     */
    @JvmName("hhcegsiwftemgmua")
    public suspend fun livenessProbe(argument: suspend ProbeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.livenessProbe = mapped
    }

    /**
     * @param value Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
     */
    @JvmName("pvoxewyvuplswjlh")
    public suspend fun readinessProbe(`value`: ProbeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbe = mapped
    }

    /**
     * @param argument Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
     */
    @JvmName("hwrvspsxnqkakvqu")
    public suspend fun readinessProbe(argument: suspend ProbeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readinessProbe = mapped
    }

    /**
     * @param value This verifies whether the application within a container is started. Startup probes run before any other probe, and, unless it finishes successfully, disables other probes.
     */
    @JvmName("pygtvgwfdlnyrael")
    public suspend fun startupProbe(`value`: ProbeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startupProbe = mapped
    }

    /**
     * @param argument This verifies whether the application within a container is started. Startup probes run before any other probe, and, unless it finishes successfully, disables other probes.
     */
    @JvmName("akalnuqhmumqvytb")
    public suspend fun startupProbe(argument: suspend ProbeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.startupProbe = mapped
    }

    internal fun build(): PoolEnvironmentConfigurationArgs = PoolEnvironmentConfigurationArgs(
        environmentId = environmentId,
        environmentVariables = environmentVariables,
        livenessProbe = livenessProbe,
        readinessProbe = readinessProbe,
        startupProbe = startupProbe,
    )
}
