@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RecurrenceFrequency
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The workflow trigger recurrence for ComputeStartStop schedule type.
 * @property frequency [Required] The frequency to trigger schedule.
 * @property interval [Required] Specifies schedule interval in conjunction with frequency
 * @property schedule [Required] The recurrence schedule.
 * @property startTime The start time in yyyy-MM-ddTHH:mm:ss format.
 * @property timeZone Specifies time zone in which the schedule runs.
 * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
 */
public data class RecurrenceArgs(
    public val frequency: Output<Either<String, RecurrenceFrequency>>? = null,
    public val interval: Output<Int>? = null,
    public val schedule: Output<RecurrenceScheduleArgs>? = null,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceArgs.builder()
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecurrenceArgs].
 */
@PulumiTagMarker
public class RecurrenceArgsBuilder internal constructor() {
    private var frequency: Output<Either<String, RecurrenceFrequency>>? = null

    private var interval: Output<Int>? = null

    private var schedule: Output<RecurrenceScheduleArgs>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("dxtpbgooukgrdgvq")
    public suspend fun frequency(`value`: Output<Either<String, RecurrenceFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value [Required] Specifies schedule interval in conjunction with frequency
     */
    @JvmName("rdcdhvvvpaxtsxxe")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value [Required] The recurrence schedule.
     */
    @JvmName("hohlynufyaroocjw")
    public suspend fun schedule(`value`: Output<RecurrenceScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value The start time in yyyy-MM-ddTHH:mm:ss format.
     */
    @JvmName("exwibyfxwtbramqa")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("fssfqkkfpyeqpdek")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("ojeibktxufivypem")
    public suspend fun frequency(`value`: Either<String, RecurrenceFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("ogmhrtnypykbuiep")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecurrenceFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("dqsfhfeiblyydfsg")
    public fun frequency(`value`: RecurrenceFrequency) {
        val toBeMapped = Either.ofRight<String, RecurrenceFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value [Required] Specifies schedule interval in conjunction with frequency
     */
    @JvmName("aihtuddrwjixtvnr")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value [Required] The recurrence schedule.
     */
    @JvmName("ikcojycqwwlgpjti")
    public suspend fun schedule(`value`: RecurrenceScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument [Required] The recurrence schedule.
     */
    @JvmName("dcfpntjetitwjcrp")
    public suspend fun schedule(argument: suspend RecurrenceScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrenceScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value The start time in yyyy-MM-ddTHH:mm:ss format.
     */
    @JvmName("llscxjxjurfignim")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("avnhyymwewprbofk")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): RecurrenceArgs = RecurrenceArgs(
        frequency = frequency,
        interval = interval,
        schedule = schedule,
        startTime = startTime,
        timeZone = timeZone,
    )
}
